/*******************************************************************************
 * Copyright (c) 2010- Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.util.binary;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.EnumSet;

/**
 * BinaryFile of multiple cache windows.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class BinaryFile2 {

	static enum Flag { 
		File,     // The block represents the contents in file at file_pos
		Memory,   // Has allocated memory, and the data is in memory
		Cache     // The memory buffer reflects the contents in the file - it is cache
	}
	static class Block {
		// size of the block
		int size;
		// Position in file, valid if File-flag is enabled 
		long file_pos;
		// Memory buffer, valid if Memory-flag is enabled
		byte buf[];
		// Last read time of virtual time code
		int access_time; 
		// Flags
		EnumSet<Flag> flags;
		// Next block in a linked list
		Block next;
	}
	
	RandomAccessFile raf;
	File file;
	ByteOrder order = ByteOrder.BIG_ENDIAN;
	Block first = null;
	int buf_size;
	long pointer = 0;
	
	public BinaryFile2(RandomAccessFile file, int buf_size) throws IOException
	{
		this.raf = file;
		this.buf_size = buf_size;
	}

	public BinaryFile2(File file, int buf_size) throws IOException
	{
		this.raf = new RandomAccessFile(file, "rw");
		this.file = file;
		this.buf_size = buf_size;
	}

	/**
	 * Closes the object. Note, this will close the input random access file.
	 * This method may be called several times.
	 *  
	 * @throws IOException
	 */
	public synchronized void close() throws IOException {
		if (raf==null) return;
		flush();
		pointer = -1;
		raf.close();
		raf = null;
		first = null;
	}
	
	public File file() {
		return file;
	}
	
	public RandomAccessFile getRandomAccessFile() {
		return raf;
	}
	
	public ByteOrder order() {
		return order;
	}

	public void order(ByteOrder order) {
		if (order==null) throw new IllegalArgumentException("null argument");
		this.order = order;
	}
	
	/**
	 * Complete flush. After this call all dirty blocks are flushed into disk.
	 * The sum of memory blocks will be less than buf_size.
	 * 
	 * @throws IOException
	 */
	public void flush() throws IOException {
		// Flush
		
		// Prune until memory blocks use less memory than buf_size
	}
	
}

