/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.units;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;

import org.simantics.databoard.units.internal.library.UnitConversion;
import org.simantics.databoard.units.internal.library.UnitLibrary;
import org.simantics.databoard.units.internal.parser.UnitParser;

public class ConverterCreator extends UnitParser implements TObjectIntProcedure<String> {
	
	UnitLibrary library;
	TObjectIntHashMap<String> exponents = new TObjectIntHashMap<String>();
	double scale = 1.0;
	int magnitude = 0;
	
	public ConverterCreator(UnitLibrary library) {
		this.library = library;
	}
	
	@Override
	public void visit(String baseUnit, int exponent) {
		if(exponents.adjustOrPutValue(baseUnit, exponent, exponent)==0)
			exponents.remove(baseUnit);
	}
	
	public IUnitConverter createConverter() {
		if(exponents.isEmpty())
			return IdentityConverter.INSTANCE;
		TObjectIntHashMap<String> oldExponents = exponents;
		exponents = new TObjectIntHashMap<String>();
		oldExponents.forEachEntry(this);
		if(exponents.isEmpty()) {
			if(magnitude == 0 && scale == 1.0)
				return IdentityConverter.INSTANCE;
			else
				return new LinearConverter(scale * Math.pow(10.0, magnitude));
		}
		else {
//			for(String u : exponents.keys(new String[exponents.size()]))
//				System.out.println(u + exponents.get(u));
			return null;
		}
	}

	@Override
	public boolean execute(String unit, int exponent) {
		UnitConversion conversion = library.getConversion(unit);
		if(conversion == null) {
			if(exponents.adjustOrPutValue(unit, exponent, exponent)==0)
				exponents.remove(unit);
		}
		else {
			if(conversion.scale != 1.0)
				scale *= Math.pow(conversion.scale, exponent);
			magnitude += conversion.magnitude * exponent;
			for(int i=0;i<conversion.baseUnits.length;++i) {
				String u = conversion.baseUnits[i];
				int exp = conversion.exponents[i] * exponent;
				if(exponents.adjustOrPutValue(u, exp, exp)==0)
					exponents.remove(u);
			}
		}
		return true;
	}
	
}
