/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.type;

import java.util.Set;

import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class ByteType extends NumberType {
    
    public ByteType() {}
    public ByteType(String unit) {
    	setUnit( unit );
    }
    public ByteType(String unit, String range) {
    	setUnit( unit );
    	setRange(range);
    }
    public ByteType(String unit, Range range) {
    	setUnit( unit );
    	setRange(range);
    }
    
    public byte minValue() {
    	Range range = getRange();
    	if (range==null) return Byte.MIN_VALUE;
    	Limit l = range.getLower();
    	byte value = l.getValue().byteValue();
    	if (l.isExclusive()) value++;
    	return value;
    }
    
    public byte maxValue() {
    	Range range = getRange();
    	if (range==null) return Byte.MAX_VALUE;
    	Limit l = range.getUpper();
    	byte value = l.getValue().byteValue();
    	if (l.isExclusive()) value--;
    	return value;
    }    
    
    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
		if (this==obj) return true;
		if ( !hasEqualMetadata(obj) ) return false;
		return obj instanceof ByteType;
    }

    @Override
    public int hashCode() {
    	return metadataHashCode() + 0x436765;
    }
    
	@Override
	public void accept(Visitor1 v, Object obj) {
	    v.visit(this, obj);        
	}

	@Override
	public <T> T accept(Visitor<T> v) {
	    return v.visit(this);
	}	
	
}
