package org.simantics.databoard.serialization;

import org.simantics.databoard.binding.Binding;

/**
 * Serialization scheme creates serializers for binding requests.
 * 
 * {@link DefaultSerializerFactory} is a serialization scheme that follows
 * Databoard serialization format specification. It can create serialization
 * for any binding. 
 * 
 * @author Toni Kalajainen
 */
public interface SerializerScheme {

	/**
	 * Get binding of a data type
	 * 
	 * @param binding
	 * @return binding 
	 * @throws SerializerConstructionException if data type is not supported
	 */
	Serializer getSerializer(Binding binding) throws SerializerConstructionException;

	/**
	 * Get binding of a data type
	 * 
	 * @param binding
	 * @return binding 
	 * @throws RuntimeSerializerConstructionException if data type is not supported
	 */
	Serializer getSerializerUnchecked(Binding binding) throws RuntimeSerializerConstructionException;

	/**
	 * Tests if the scheme supports a binding
	 * 
	 * @param binding
	 * @return true if the binding is supported by the scheme
	 */
	boolean supportsBinding(Binding binding);
	
}
