/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.parser.ast.value.visitor;

import org.simantics.databoard.parser.ast.value.AstArray;
import org.simantics.databoard.parser.ast.value.AstBoolean;
import org.simantics.databoard.parser.ast.value.AstFloat;
import org.simantics.databoard.parser.ast.value.AstInteger;
import org.simantics.databoard.parser.ast.value.AstMap;
import org.simantics.databoard.parser.ast.value.AstNull;
import org.simantics.databoard.parser.ast.value.AstRecord;
import org.simantics.databoard.parser.ast.value.AstReference;
import org.simantics.databoard.parser.ast.value.AstString;
import org.simantics.databoard.parser.ast.value.AstTaggedValue;
import org.simantics.databoard.parser.ast.value.AstTuple;
import org.simantics.databoard.parser.ast.value.AstVariant;

public interface AstValueVisitorVoid {

	void visit(AstMap astMap);
	void visit(AstBoolean astBoolean);
	void visit(AstInteger astInteger);
	void visit(AstNull astNull);
	void visit(AstRecord astRecord);
	void visit(AstReference astReference);
	void visit(AstString astString);
	void visit(AstTaggedValue astTaggedValue);
	void visit(AstTuple astTuple);
	void visit(AstVariant astVariant);
	void visit(AstFloat astFloat);
	void visit(AstArray astArray);

}
