/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.parser.ast.value.visitor;

import org.simantics.databoard.parser.ast.value.AstArray;
import org.simantics.databoard.parser.ast.value.AstBoolean;
import org.simantics.databoard.parser.ast.value.AstFloat;
import org.simantics.databoard.parser.ast.value.AstInteger;
import org.simantics.databoard.parser.ast.value.AstMap;
import org.simantics.databoard.parser.ast.value.AstNull;
import org.simantics.databoard.parser.ast.value.AstRecord;
import org.simantics.databoard.parser.ast.value.AstReference;
import org.simantics.databoard.parser.ast.value.AstString;
import org.simantics.databoard.parser.ast.value.AstTaggedValue;
import org.simantics.databoard.parser.ast.value.AstTuple;
import org.simantics.databoard.parser.ast.value.AstVariant;

public interface AstValueVisitor<T> {

	T visit(AstArray astArray);
	T visit(AstBoolean astBoolean);
	T visit(AstFloat astFloat);
	T visit(AstInteger astInteger);
	T visit(AstMap astMap);
	T visit(AstNull astNull);
	T visit(AstRecord astRecord);
	T visit(AstReference astReference);
	T visit(AstString astString);
	T visit(AstTaggedValue astTaggedValue);
	T visit(AstTuple astTuple);
	T visit(AstVariant astVariant);

}
