/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.parser.ast.value;

import org.simantics.databoard.parser.ast.value.visitor.AstValueVisitor;
import org.simantics.databoard.parser.ast.value.visitor.AstValueVisitorVoid;

public class AstTaggedValue implements AstValue {
	public final String tag;
	public final AstValue value;
	
	public AstTaggedValue(String tag, AstValue value) {
		this.tag = tag;
		this.value = value;
	}	
	
	@Override
	public <T> T accept(AstValueVisitor<T> v) {
		return v.visit(this);
	}

	@Override
	public void accept(AstValueVisitorVoid v) {
		v.visit(this);
	}	
}
