/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.parser.ast.type.visitor;

import org.simantics.databoard.parser.ast.type.AstArrayType;
import org.simantics.databoard.parser.ast.type.AstComponent;
import org.simantics.databoard.parser.ast.type.AstRecordType;
import org.simantics.databoard.parser.ast.type.AstTupleType;
import org.simantics.databoard.parser.ast.type.AstType;
import org.simantics.databoard.parser.ast.type.AstTypeReference;
import org.simantics.databoard.parser.ast.type.AstUnionType;

public class AstTypePrinter implements AstTypeVisitorVoid {
	StringBuilder b = new StringBuilder();	

	@Override
	public void visit(AstArrayType arrayType) {
		arrayType.componentType.accept(this);
		b.append("[]");
	}

	@Override
	public void visit(AstRecordType recordType) {
		b.append("{");
		boolean first = true;
		for(AstComponent component : recordType.components) {
			if(first)
				first = false;
			else
				b.append(", ");
			b.append(component.name);
			b.append(" : ");
			component.type.accept(this);
		}
		b.append("}");		
	}

	@Override
	public void visit(AstTupleType tupleType) {
		b.append("(");
		boolean first = true;
		for(AstType component : tupleType.components) {
			if(first)
				first = false;
			else
				b.append(", ");			
			component.accept(this);
		}
		b.append(")");			
	}

	@Override
	public void visit(AstTypeReference typeReference) {
		b.append(typeReference.name);
		if(!typeReference.parameters.isEmpty()) {
			b.append("(");
			boolean first = true;
			for(AstType component : typeReference.parameters) {
				if(first)
					first = false;
				else
					b.append(", ");			
				component.accept(this);
			}
			b.append(")");	
		}
	}

	@Override
	public void visit(AstUnionType unionType) {
		boolean first = true;
		for(AstComponent component : unionType.components) {
			if(first)
				first = false;
			else
				b.append(" | ");
			b.append(component.name);
			b.append(' ');
			component.type.accept(this);
		}
	}
	
	@Override
	public String toString() {
		return b.toString();
	}
}
