/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.parser.ast.type;

import java.util.List;

import org.simantics.databoard.parser.ast.type.visitor.AstTypeVisitor;
import org.simantics.databoard.parser.ast.type.visitor.AstTypeVisitorVoid;

public class AstUnionType extends AstType {
	public final List<AstComponent> components;

	public AstUnionType(List<AstComponent> components) {
		this.components = components;
	}	
	
	public void addComponent(String name, AstType type) {
		components.add(new AstComponent(name, type));
	}
	
	@Override
	public void accept(AstTypeVisitorVoid v) {
		v.visit(this);
	}		
	
	@Override
	public <T> T accept(AstTypeVisitor<T> v) {
		return v.visit(this);
	}	
}
