/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.parser;

public class StringEscapeUtils {

	public static String escape(String str) {
		StringBuilder b = new StringBuilder();
		for(int i = 0;i<str.length();++i) {
			char c = str.charAt(i);
			switch(c) {
			case '\n':
				b.append("\\n");
				break;
			case '\r':
				b.append("\\r");
				break;
			case '\t':
				b.append("\\t");
				break;
			case '\b':
				b.append("\\b");
				break;
			case '\f':
				b.append("\\f");
				break;
			case '\\':
				b.append("\\\\");
				break;
			default:
				b.append(c);
			}
		}
		return b.toString();
	}

	public static String unescape(String str) {
		StringBuilder b = new StringBuilder();
		for(int i = 0;i<str.length();++i) {
			char c = str.charAt(i);
			if(c == '\\') {
				c = str.charAt(++i);
				switch(c) {
				case 'n':
					b.append('\n');
					break;
				case 'r':
					b.append('\r');
					break;
				case 't':
					b.append('\t');
					break;
				case 'b':
					b.append('\b');
					break;
				case 'f':
					b.append('\f');
					break;
				default:
					b.append(c);
				}
			}
			else
				b.append(c);
		}
		return b.toString();
	}
	
}
