/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.method;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.UnionType;


public class MethodTypeDefinition implements Comparable<MethodTypeDefinition> {

	public static Binding BINDING = Bindings.getBindingUnchecked( MethodTypeDefinition.class );
	
	String name;
	MethodType type;
	
	private transient int hash; 	
	
	public MethodTypeDefinition(String name, MethodType type)
	{
		this.name = name;
		this.type = type;
		hash = name.hashCode() + type.hashCode()*7;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
		hash = name.hashCode() + type.hashCode()*7;
	}
	
	public MethodType getType() {
		return type;
	}
	
	@Override
	public String toString() {
		Datatype void_ = Datatypes.getDatatypeUnchecked(void.class); 
		StringBuilder sb = new StringBuilder();
		
		Datatype res = type.getResponseType();
		Datatype req = type.getRequestType();
		UnionType err = (UnionType) type.getErrorType();

		sb.append("method ");
		sb.append(name);
		sb.append(" : ");
		sb.append(req.toSingleLineString());
		sb.append(" -> ");
		
		if (res.equals(void_))
			sb.append("void");
		else
			sb.append(res.toSingleLineString());
		
		if (err.getComponentCount()>0) {
			sb.append(" throws ");
			for (int i=0; i<err.getComponentCount(); i++) {
				if (i>0) sb.append(", ");
				Component c = err.getComponent(i); 
				sb.append( c.name );
				sb.append( c.type.toSingleLineString() );
			}
		}
		return sb.toString();
	}

	@Override
	public int hashCode() {
		return hash;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof MethodTypeDefinition==false) return false;
		MethodTypeDefinition other = (MethodTypeDefinition) obj;
		return other.name.equals(name) && other.type.equals(type);
	}

	@Override
	public int compareTo(MethodTypeDefinition o) {
		int c = name.compareTo( o.getName() );
		if (c!=0) return c;
		c = type.compareTo( o.getType() );
		return c;
	}
	
}

