/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.method;

import org.simantics.databoard.Methods;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.UnionBinding;

/**
 * MethodTypeBinding is a binding of MethodType (Request, Response and Error data types)
 * to a Java Class.
 * 
 * @see Methods#getMethodTypeBinding(java.lang.reflect.Method)
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class MethodTypeBinding {
	
	MethodTypeDefinition methodDefinition;

	RecordBinding requestBinding;
	Binding responseBinding;
	UnionBinding errorBinding;

	public MethodTypeBinding(String methodName, RecordBinding requestBinding, Binding responseBinding, UnionBinding errorBinding)
	{
		if (methodName==null||requestBinding==null||responseBinding==null||errorBinding==null)
			throw new IllegalArgumentException("null arg");
		this.methodDefinition = new MethodTypeDefinition(methodName, new MethodType(requestBinding.type(), responseBinding.type(), errorBinding.type()));
		this.requestBinding = requestBinding;
		this.responseBinding = responseBinding;
		this.errorBinding = errorBinding;
	}
	
	public MethodTypeBinding(MethodTypeDefinition methodDescription, RecordBinding requestBinding, Binding responseBinding, UnionBinding errorBinding)
	{
		if (methodDescription==null||requestBinding==null||responseBinding==null||errorBinding==null)
			throw new IllegalArgumentException("null arg");
		this.methodDefinition = methodDescription;
		this.requestBinding = requestBinding;
		this.responseBinding = responseBinding;
		this.errorBinding = errorBinding;
	}

	public MethodTypeDefinition getMethodDefinition() {
		return methodDefinition;
	}
	
	public MethodType getMethodType() {
		return methodDefinition.getType();
	}
	
	public String getName() {
		return methodDefinition.getName();
	}

	public RecordBinding getRequestBinding() {
		return requestBinding;
	}

	public Binding getResponseBinding() {
		return responseBinding;
	}

	public UnionBinding getErrorBinding() {
		return errorBinding;
	}
	/*
	// Puts error classes into an union type 
	public static Binding error(final Class<?>...errorClasses)
	{
   		UnionType ut = new UnionType();
		UnionBinding ub = new UnionBinding() {
			@Override
			public Object create(int tag, Object value)
			throws BindingException {
				return value;
			}
			@Override
			public int getTag(Object obj) throws BindingException {
				for (int i=0; i<errorClasses.length; i++)
					if (errorClasses[i].isInstance(obj))
						return i;
				throw new BindingException("pl");
			}
			@Override
			public Object getValue(Object obj) throws BindingException {
				return obj;
			}
			@Override
			public boolean isInstance(Object obj) {
				for (Class<?> clazz : errorClasses)
					if (clazz.isInstance(obj)) 
						return true;
				return false;
			}};
		ub.type = ut;
		ub.componentBindings = new Binding[errorClasses.length];
   		ut.components = new Component[errorClasses.length];
   		for (int i=0; i<errorClasses.length; i++)
   		{
   			Component c = new Component();
   			c.name = errorClasses[i].getName();
   			c.type = DataTypes.getDataType(errorClasses[i]);
   			ut.components[i] = c;
   			ub.componentBindings[i] = DataTypes.getBinding(errorClasses[i]);
   		}
		
		return ub;
	}

	// Puts request arguments to record type   
	public static Binding request(Class<?>...argumentClasses)
	{
		return null;
	}
	
	public static Binding response(Class<?> response)
	{
		return DataTypes.getBinding(response);
	}
*/	
}

