/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.method;

import org.simantics.databoard.type.Datatype;

public class MethodType implements Comparable<MethodType> {
	
	// RecordType, one component for each argument
	Datatype requestType;
	// anything
	Datatype responseType;
	// UnionType
	Datatype errorType;
	
	transient int hash; 
	
	/**
	 * 
	 * @param requestType
	 * @param responseType
	 * @param errorType must be union
	 */
	public MethodType(Datatype requestType, Datatype responseType, Datatype errorType)
	{
		this.requestType = requestType;
		this.responseType = responseType;
		this.errorType = errorType;
		hash = requestType.hashCode() + responseType.hashCode()*13 + errorType.hashCode()*23;
	}
	
	public Datatype getRequestType()
	{
		return requestType;
	}
	
	public Datatype getResponseType()
	{
		return responseType;
	}
	
	public Datatype getErrorType()
	{
		return errorType;
	}
	
	@Override
	public String toString() {
		return requestType.toSingleLineString()+" -> " + responseType.toSingleLineString()+ " throws " + errorType.toSingleLineString();
	}
	

	@Override
	public int hashCode() {
		return hash;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof MethodType == false) return false;
		MethodType other = (MethodType) obj;
		return other.requestType.equals(requestType) && 
			other.responseType.equals(responseType) &&
			other.errorType.equals(errorType);
	}

	@Override
	public int compareTo(MethodType o) {
		return 0;
	}
	
}

