/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.method;


/**
 * A wrapper to an exception that occured when trying to invoke a methods.
 * For instance, file or network error or closed session.
 * 
 * Wraps exeptions like SessionClosedException, and IOException.
 * This exception does not cover errors that occure during the invocation
 * of the method. 
 *
 * TODO Make non-runtime
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class InvokeException extends RuntimeException {

	private static final long serialVersionUID = 1L;
	
	public InvokeException(Exception cause) {
		super(cause);
	}

	public InvokeException(String message, Exception cause) {
		super(message, cause);
	}
	
}

