/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.method;

public class InterfaceDefinition {

	String name;
	Interface type;
	
	private transient int hash; 	
	
	public InterfaceDefinition(String name, Interface type)
	{
		this.name = name;
		this.type = type;
		hash = name.hashCode() + type.hashCode()*7;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
		hash = name.hashCode() + type.hashCode()*7;
	}
	
	public Interface getType() {
		return type;
	}
	
	@Override
	public String toString() {
		return name+" = "+type;
	}

	@Override
	public int hashCode() {
		return hash;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof InterfaceDefinition==false) return false;
		InterfaceDefinition other = (InterfaceDefinition) obj;
		return other.name.equals(name) && other.type.equals(type);
	}
	
}

