package org.simantics.databoard.forms;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;

public class DataboardDialog extends Dialog {
	
	RecordBinding formBinding;
	Object initialValues;
	String title;
	Object result;
    DataboardForm form;
    Composite composite;
    
    /**
     * Create dialog window
     * 
     * @param parentShell
     * @param title
     * @param formBinding
     * @param initialValues values according to formBinding or null
     */
	public DataboardDialog(Shell parentShell, String title, RecordBinding formBinding, Object initialValues) {		
		super(parentShell);
		this.formBinding = formBinding;
		this.initialValues = initialValues;
		this.title = title;
		
		setBlockOnOpen(true);
		setShellStyle(SWT.RESIZE | SWT.TITLE | SWT.CLOSE | SWT.BORDER);
	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);
		createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);
	}

	@Override
	protected Control createDialogArea(Composite parent) {
	    ScrolledComposite scroll = new ScrolledComposite(parent, SWT.V_SCROLL);
	    composite = new Composite(scroll, 0);
        scroll.setContent(composite);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(false);
		form = new DataboardForm();
	    form.setFirstColumnWidth(0);
	    form.addFields(composite, formBinding.type());
	    
		composite.setLayout( new GridLayout(3, false) );			
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 3, 1));
		
		if ( initialValues != null ) {
			try {
				form.writeFields(composite, formBinding, initialValues);
			} catch (AccessorException e) {
				e.printStackTrace();
			} catch (BindingException e) {
				e.printStackTrace();
			} catch (AccessorConstructionException e) {
				e.printStackTrace();
			}			
		}
		
	    composite.pack();
		
		return scroll;
	}

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(title);
    }
    
	@Override
	protected void okPressed() {
		try {
			result = formBinding.createDefault();
			form.readFields(composite, formBinding, result);
		} catch (BindingException e) {
			e.printStackTrace();
			result = null;
		} catch (AccessorConstructionException e) {
			e.printStackTrace();
			result = null;
		} catch (AccessorException e) {
			e.printStackTrace();
			result = null;
		}
		super.okPressed();
	}
	
	@Override
	protected void cancelPressed() {
		result = null;
		super.cancelPressed();
	}

	public Object getResult() {
		return result;
	}
	
}