package org.simantics.databoard.container;

import java.util.TreeMap;

import org.simantics.databoard.binding.mutable.Variant;

/**
 * This is a container format primarly for encoding data to file system.
 * It adds to the actual data encoded as a variant some metadata, format
 * name and version information.
 * @author Hannu Niemist&ouml;
 */
public class DataContainer {
    /**
     * Format name that tells how the data is used. 
     * Applications use format name to decide if the file can 
     * be used for the operation the user requested.
     */
    public String format;
    /**
     * Version number of the content format. Increased every
     * time the data type or the interpretation of the data
     * changes.
     */
    public int version;
    /**
     * May contain arbitrary metadata about the data such as
     * author, export data etc.
     */
    public TreeMap<String, Variant> metadata;
    /**
     * The actual data content.
     */
    public Variant content;
    
    public DataContainer() {
    }
    
    public DataContainer(String format, int version,
            TreeMap<String, Variant> metadata, Variant content) {
        this.format = format;
        this.version = version;
        this.metadata = metadata;
        this.content = content;
    }
    
    public DataContainer(String format, int version, Variant content) {
        this(format, version, new TreeMap<String,Variant>(), content);
    }
}
