package org.simantics.databoard.channel;

import org.simantics.databoard.binding.Binding;

/**
 * This interface is intended to be used by service handler implementations.
 *
 * @author Toni Kalajainen <toni.kalajainen@iki.fi>
 */
public interface ServiceRequest {
	
	/**
	 * Context is an idetification of the requester. The actual implementation
	 * depends on the implementation of the channel. 
     *   
     * For example: TCP based implementation can publish user identification, 
     * security policy, application instance certificate, session identifier, 
     * socket address, etc..
	 * 
     * Application local implementation may carry no data. <p>
	 * 
	 * @return client context
	 */
	Object getClientContext();
	
	/**
	 * Get the command specification of the request.
	 *  
	 * The identifier of the spec is a well-known id of the requested service.
	 * 
	 * @return command specification
	 */
	CommandSpec getCommandSpec();
	
	/**
	 * Get an access to the request object.
	 * 
	 * @param binding 
	 * @return access to request
	 */
	Object getRequest(Binding binding);
	
	/**
	 * Send a successful result. Result can be sent from any thread but only once.
	 * 
	 * @param binding
	 * @param result
	 */
	void sendResult( Binding binding, Object result );
	
	/**
	 * Send an error result. Result can be sent from any thread but only once. 
	 * 
	 * @param binding
	 * @param error
	 */
	void sendError( Binding binding, Object error );		
		
}
