package org.simantics.databoard.channel;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;

/**
 * This class carries a specification for a single command. 
 *
 * @author Toni Kalajainen <toni.kalajainen@iki.fi>
 */
public class CommandSpec {

	/** Well-known id of the service */
	public final Variant commandId;
	
	/** Description of the request data. Typically a record type. */
	public final Datatype requestType;
	
	/** Description of the response data. Typically a record type. */
	public final Datatype responseType;
	
	/** Description of the error data. Typically a union type. */
	public final Datatype errorType;
	
	public CommandSpec(Variant commandId, Datatype requestType, Datatype responseType, Datatype errorType) {
		this.commandId = commandId;
		this.requestType = requestType;
		this.responseType = responseType;
		this.errorType = errorType;
	}
	
}
