/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.reflection;

import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;

/**
 * RecordBinding that represents a class
 */
public abstract class ClassBinding extends RecordBinding {

	public final ClassInfo ci;

	/**
	 * Create binding for a class. 
	 * 
	 * @param ci
	 * @throws BindingConstructionException
	 */
	public ClassBinding(ClassInfo ci)
	{
		this.ci = ci;		
	}

	/**
	 * Create binding for a class. 
	 * 
	 * @param clazz
	 * @throws BindingConstructionException
	 */
	public ClassBinding(Class<?> clazz) throws BindingConstructionException
	{
		this( ClassInfo.getInfo(clazz) );
	}
	
	public Class<?> getClazz()
	{
		return ci.clazz;
	}
	
	@Override
	protected boolean baseEquals(Object obj) {
		return super.baseEquals(obj) && ((ClassBinding)obj).ci.equals(ci);
	}

	@Override
	public int baseHashCode() {
		return super.baseHashCode() + 17 * ci.hashCode();
	}
}
