/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.reflection;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;

/**
 * Binding provider is an interface for providers that provide context-specific
 * or hand-written bindings for the whole binding construction mechanism.
 *
 * @author toni.kalajainen@semantum.fi
 */
public interface BindingProvider {

	/**
	 * Construct a binding for a request. This method returns null if a binding
	 * cannot be provided by this factory. Exception is thrown if construction
	 * is expected to success but fails for a reason.
	 *  
	 * If this class constructs a compositive type: Array, Map, Optional, 
	 * Record or Union, the composite types/fields need not be filled, and 
	 * should be left null. They are filled by the caller.  
	 * 
	 * @param request
	 * @param mainFactory master factory
	 * @return binding or <code>null</code> 
	 * @throws BindingConstructionException
	 */
	Binding provideBinding(ClassBindingFactory mainFactory, BindingRequest request) throws BindingConstructionException;
	
}
