/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.mutable;

import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.type.StringType;

/**
 * Binds StringType to {@link MutableString}
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class MutableStringBinding extends StringBinding {

	public MutableStringBinding(StringType type) {
		super(type);
	}

	@Override
	public Object create(String value) {
		MutableString result = new MutableString();
		result.value = value;
		return result;
	}

	@Override
	public String getValue(Object o) throws BindingException {
		MutableString result = (MutableString)o;
		return (String) result.value;		
	}

	@Override
	public boolean isInstance(Object obj) {
		return (obj instanceof MutableString) && ( ((MutableString)obj).value instanceof String );
	}

	@Override
	public void setValue(Object o, String newValue) throws BindingException {
		MutableString result = (MutableString)o;
		result.value = newValue;
	}	
	
}


