/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.mutable;

import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.primitives.MutableLong;
import org.simantics.databoard.type.LongType;

/**
 * Binds LongType to {@link MutableLong}
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class MutableLongBinding extends LongBinding {
	
	public MutableLongBinding(LongType type) {
		super(type);
	}

	@Override
	public Object create(long value) {
		MutableLong result = new MutableLong();
		result.value = value;
		return result;
	}

	@Override
	public Object create(Long value) {
		MutableLong result = new MutableLong();
		result.value = value;
		return result;
	}

	@Override
	public Object create(Number value) {
		MutableLong result = new MutableLong();
		result.value = value.longValue();
		return result;
	}

	@Override
	public Object create(String value) throws BindingException {
		try {
			MutableLong result = new MutableLong();
			result.value = Long.valueOf(value);
			return result;
		} catch (java.lang.NumberFormatException e) {
			throw new BindingException( e );
		}
	}

	@Override
	public long getValue_(Object o) throws BindingException {
		MutableLong result = (MutableLong) o;
		return result.value;
	}

	@Override
	public Long getValue(Object o) throws BindingException {
		MutableLong result = (MutableLong) o;
		return result.value;
	}

	@Override
	public boolean isInstance(Object obj) {
		return obj instanceof MutableLong;
	}

	@Override
	public void setValue(Object obj, long value) throws BindingException {
		MutableLong result = (MutableLong) obj;
		result.value = value;
	}

	@Override
	public void setValue(Object obj, Number value) throws BindingException {
		MutableLong result = (MutableLong) obj;
		result.value = value.longValue();
	}
			
}

