/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.OptionalType;

/**
 * This implementation binds OptionalType to null / Object assignment.
 *
 * @author Toni Kalajainen
 */
public class OptionalBindingDefault extends OptionalBinding {

    public OptionalBindingDefault(Binding componentBinding) {
		super(componentBinding);
	}

	public OptionalBindingDefault(OptionalType type, Binding componentBinding) {
		super(type, componentBinding);
	}

	/**
     * Create result with no value
     * 
     * @return no value
     */
    public Object createNoValue() {
    	return null;
    }
    
    /**
     * Create result with a value
     * 
     * @param value
     * @return argument that contains a value
     */
    public Object createValue(Object value) 
    throws BindingException {
    	// Only this implementation, sub-classes may have another behaviour
    	if (value==null) throw new BindingException("Cannot bind null as a value");
    	return value;
    }

    /**
     * Tests whether arg contains a value
     * 
     * @param arg 
     * @return true if arg contained a value
     */
    public boolean hasValue(Object arg) {
    	return arg!=null;
    }
    
    /**
     * Get the non-null value, the arg did not contain a value,
     * BindingException is thrown. 
     *  
     * @param arg argument that contains a value
     * @return the composite value
     * @throws BindingException
     */
    public Object getValue(Object arg) 
    throws BindingException {
    	if (arg == null) throw new BindingException("Optional value ("+arg+") does not contain value.");
    	return arg;
    }

    public void setValue(Object optional, Object componentValue)
    throws BindingException {
    	if (componentValue==optional) return;
    	throw new UnsupportedOperationException("Cannot set new value to container of java.lang.Object");
    }
    
    public void setNoValue(Object optional)
    throws BindingException
    {    	
    	if (optional==null) return;
    	throw new UnsupportedOperationException("Cannot remove value from container of java.lang.Object");
    }

	@Override
	public boolean isInstance(Object obj) {
		if (obj==null) return true;
		return componentBinding.isInstance(obj);
	}
	
	@Override
	public boolean isImmutable() {
		return true;
	}
	
	
}

