/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.LongType;

public class LongBindingDefault extends LongBinding {

	public LongBindingDefault(LongType type) {
		super(type);
	}
	
	public Object create(long value) {
		return Long.valueOf(value);
	}
	
	public Object create(Long value) {
		return Long.valueOf(value);
	}
	
	@Override
	public Object create(Number value) 
	{
		if (value.getClass()==Long.class) return value;
		return Long.valueOf( value.longValue() );
	}	

	@Override
	public Object create(String value) throws BindingException {
		try {
			return Long.parseLong(value);
		} catch (java.lang.NumberFormatException e) {
			throw new BindingException( e );
		}
	}
	
	public Long getValue(Object o) 
	throws BindingException {
		if (o.getClass()!=Long.class)
			throw new BindingException("Unexpected class "+o.getClass().getSimpleName()+", Long expected");		
		return ((Long)o);
	}

	public long getValue_(Object o) 
	throws BindingException 
	{
		if (o.getClass()!=Long.class)
			throw new BindingException("Unexpected class "+o.getClass().getSimpleName()+", Long expected");		
		return ((Long)o);
	}
	
	@Override
	public void setValue(Object obj, Number value) throws BindingException {
		throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Long");
	}

	public void setValue(Object obj, long value) throws BindingException {
		throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Long");
	}
	
    @Override
	public boolean isInstance(Object obj) {
		return obj instanceof Long;
	}	
    
    @Override
    public boolean isImmutable() {
    	return true;
    }
	
    @Override
    public int compare(Object o1, Object o2)
    {
    	long i1 = (Long) o1;
    	long i2 = (Long) o2;
    	return (i1<i2 ? -1 : (i1==i2 ? 0 : 1));
    }    
    
}

