/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.annotations;

import java.lang.annotation.Annotation;
import java.util.Arrays;

public class UnionImpl implements Union {

	int hash;
	Class<?>[] args;
	
	public UnionImpl(Class<?>...args) {
        hash = Arrays.hashCode(args);
		this.args = args;
	}
	
	@Override
	public Class<? extends Annotation> annotationType() {
		return Union.class;
	}

	@Override
	public Class<?>[] value() {
		return args;
	}
	
	@Override
	public int hashCode() {		
		return hash;
	}
	
	@Override
	public boolean equals(Object obj) {
		if ( obj instanceof Union == false ) return false;
		Union other = (Union) obj;
		Class<?>[] classArray1 = args;
		Class<?>[] classArray2 = other.value();
		
		return Arrays.deepEquals(classArray1, classArray2);
	}
}
