/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.reference;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.util.URIUtil;

/**
 * Map Value
 * "<key>/"
 */
public class KeyReference extends ChildReference {

	static Adapter VARIANT_TO_STRING_ADAPTER = Bindings.getAdapterUnchecked(Bindings.VARIANT, Bindings.STR_VARIANT);
	
	public Variant key;
	
	public KeyReference() {
	}
	
	public KeyReference(Binding keyBinding, Object key) {
		this.key = new Variant(keyBinding, key);
	}
	
	public KeyReference(Variant key) {
		this.key = key.clone();
	}
	
	public KeyReference(Variant key, ChildReference child) {
		super(child);
		this.key = key.clone();
	}
	
	@Override
	public String toString(boolean labelReference) {
		String strKey = (String) VARIANT_TO_STRING_ADAPTER.adaptUnchecked(key);
		return labelReference ? URIUtil.encodeURI( strKey ) : "k-"+strKey;
	}

	@Override
	public ChildReference clone() {
		return new KeyReference(key.clone(), childReference==null ? null : childReference.clone());
	}	
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof KeyReference == false) return false;
		KeyReference other = (KeyReference) obj;
		if (!other.key.equals(key)) return false;
		if (other.hasChildReference() != hasChildReference()) return false;
		if (hasChildReference() && !other.childReference.equals(childReference)) return false;
		return true;
	}
	
	@Override
	public int hashCode() {
		int hash = 61468996 + 37 * key.hashCode();
		if (hasChildReference()) hash = 31*hash + childReference.hashCode();		
		return hash;
	}
	
	@Override
	public String toString() {
		return "["+key+"]";
	}
	
}

