/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.reference;


/**
 * Array element
 * "i-<index>/"
 */
public class IndexReference extends ChildReference {
	
	public int index;
	
	public IndexReference(int index) { this.index = index; }

	public IndexReference(int index, ChildReference child) {
		super(child);
		this.index = index;		
	}
	
	@Override
	public String toString(boolean labelReference) {
		return labelReference ? ""+index : "i-"+index;
	}
	
	public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	@Override
	public ChildReference clone() {
		return new IndexReference(index, childReference==null ? null : childReference.clone());
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof IndexReference == false) return false;
		IndexReference other = (IndexReference) obj;
		if (other.index != index) return false;
		if (other.hasChildReference() != hasChildReference()) return false;
		if (hasChildReference() && !other.childReference.equals(childReference)) return false;
		return true;
	}
	
	@Override
	public int hashCode() {
		int hash = 423423 + 37 * index;
		if (hasChildReference()) hash = 31*hash + childReference.hashCode();		
		return hash;
	}
	
}

