/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.interestset;

import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.type.UnionType;

/**
 * Interest set of Union Type.
 * 
 * @see UnionType
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class UnionInterestSet extends InterestSet {
	
	public static final UnionInterestSet MONITOR_EVERYTHING = new UnionInterestSet(true, true, null); 
	
	/** Interested in the notifications (excludes the value) */
	public boolean notification = true;
	/** Interested in the value (includes notification) */  
	public boolean value = true;
	/** Component intersts, null if no specific interest */
	public @Optional InterestSet[] componentInterests;
		
	public UnionInterestSet(boolean notification, boolean value, InterestSet[] componentInterests) {
		this.notification = notification;
		this.value = value;
		this.componentInterests = componentInterests;
	}

	/**
	 * Returns true, if interested in notification. 
	 * 
	 * @return true, if interested in notification
	 */
	public boolean inNotifications() {
		return notification | value;
	}	
	
	public boolean inNotificationsOf(int tag) {
		return notification | value | getComponentInterest(tag)!=null;
	}
	
	/**
	 * Returns true, if interested in the value  
	 * 
	 * @return true, if interested in the value
	 */
	public boolean inValues() {
		return value;
	}
	
	public boolean inValuesOf(int tag) {
		return value | getComponentInterest(tag)!=null;
	}

	/**
	 * Get interest in the component value.
	 * 
	 * @return component interest or <code>null</code>
	 */
	public InterestSet getComponentInterest(int tag) {
		if (componentInterests==null) return null;
		return componentInterests[tag];
	}
	
}

