/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.interestset;

import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.type.OptionalType;

/**
 * Interest set of an Optional Type.
 * 
 * @see OptionalType
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class OptionalInterestSet extends InterestSet {
	
	public static final OptionalInterestSet MONITOR_EVERYTHING = new OptionalInterestSet(true, true, null); 
	
	/** Interested in the notification of value assignment (excludes the value) */
	public boolean notification = true;
	/** Interested in the value (includes change) */  
	public boolean value = true;
	/** Component intersts, null if no specific interest */
	public @Optional InterestSet componentInterest;
		
	public OptionalInterestSet(boolean notification, boolean value, InterestSet componentInterest) {
		this.notification = notification;
		this.value = value;
		this.componentInterest = componentInterest;
	}
	
	/**
	 * Returns true, if interested in the value or notification 
	 * 
	 * @return true, if interested in the value 
	 */
	public boolean inValues() {
		return value | (componentInterest!=null);
	}

	/**
	 * Returns true, if interested in notification of new value assignments.
	 * 
	 * @return true, if interested in notification 
	 */
	public boolean inNotifications() {
		return notification | value | (componentInterest!=null);
	}	
	
	/**
	 * Returns component interest or <code>null</code>
	 * 
	 * @return interest of component or <code>null</code>
	 */
	public InterestSet getComponentInterest() {
		return componentInterest;
	}
	
}

