/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.file;

import java.util.Map;

import org.simantics.databoard.accessor.MapAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;

public interface FileMapAccessor extends MapAccessor, FileAccessor {

	/**
	 * Set & copy all entries from a Map Value.
	 *  
	 * If entries are removed and they have accessors, the accessors are invalidated. 
	 * 
	 * @param mapBinding
	 * @param newMap
	 * @throws BindingException binding error
	 * @throws UnsupportedOperationException cannot set a new value
	 */
	void setValueNoflush(Binding mapBinding, Object newMap) throws AccessorException;
	
	
	/**
	 * Put an entry to the map. If previous entry exists for the key, it is removed. 
	 * 
	 * @param keyBinding
	 * @param key
	 * @param valueBinding
	 * @param value
	 * @throws AccessorException
	 */
	void putNoflush(Binding keyBinding, Object key, Binding valueBinding, Object value) throws AccessorException;

	void removeNoflush(Binding keyBinding, Object key) throws AccessorException;
	
	void putAllNoflush(Binding keyBinding, Binding valueBinding, Map<Object, Object> from) throws AccessorException;
	void putAllNoflush(Binding keyBinding, Binding valueBinding, Object[] keys, Object[] values) throws AccessorException;
	void clearNoflush() throws AccessorException;
}

