/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.event;

import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;

public class ValueAssigned extends ModificationEvent {
	
	public @Optional MutableVariant newValue;

	public ValueAssigned() {}

	public ValueAssigned(MutableVariant newComponentValue) {
		this.newValue = newComponentValue;
	}
		
	public ValueAssigned(Binding binding, Object newComponentValue) {
		this.newValue = new MutableVariant(binding, newComponentValue);
	}

	public ValueAssigned(ChildReference path, MutableVariant newComponentValue) {
		this.reference = path;
		this.newValue = newComponentValue;
	}
	
	public ValueAssigned(ChildReference path, Binding binding, Object newComponentValue) {
		this.reference = path;
		this.newValue = newComponentValue == null ? null : new MutableVariant(binding, newComponentValue);
	}
	
	@Override
	public ValueAssigned clone(ChildReference newReference) {
		ValueAssigned result = new ValueAssigned(newValue);
		result.reference = newReference;
		return result;
	}
	
	@Override
	public String toString() {		
		return toRef()+"= "+newValue;
	}
	
}

