/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.event;

import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.mutable.MutableVariant;

public class UnionValueAssigned extends ModificationEvent {

	public int tag;
	public @Optional MutableVariant newValue;

	public UnionValueAssigned(ChildReference reference, int tag, MutableVariant newValue) {
		this.reference = reference;
		this.tag = tag;
		this.newValue = newValue;
	}
	
	public UnionValueAssigned(int tag, MutableVariant newValue) {
		this.tag = tag;
		this.newValue = newValue;
	}

	@Override
	public UnionValueAssigned clone(ChildReference newReference) {
		UnionValueAssigned result = new UnionValueAssigned(tag, newValue);
		result.reference = newReference;
		return result;
	}
	
	@Override
	public String toString() {		
		return toRef()+"= "+newValue;
	}
	
	
}

