/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.event;

import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;

public class OptionalValueAssigned extends ModificationEvent {
	
	public @Optional MutableVariant newValue;
	
	public OptionalValueAssigned() {}

	public OptionalValueAssigned(ChildReference reference, MutableVariant newComponentValue) {
		this.reference = reference;
		this.newValue = newComponentValue;
	}
	
	public OptionalValueAssigned(MutableVariant newComponentValue) {
		this.newValue = newComponentValue;
	}
	
	public OptionalValueAssigned(Binding binding, Object newComponentValue) {
		this.newValue = new MutableVariant(binding, newComponentValue);
	}
	
	@Override
	public OptionalValueAssigned clone(ChildReference newReference) {
		OptionalValueAssigned result = new OptionalValueAssigned(newValue);
		result.reference = newReference;
		return result;
	}	

	@Override
	public String toString() {		
		return toRef()+"= "+newValue;
	}
	
}

