/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.event;

import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.mutable.MutableVariant;

public class MapEntryRemoved extends ModificationEvent {
	
	/** The key of the entry. */
	public MutableVariant key; 	

	public MapEntryRemoved(ChildReference reference, MutableVariant key) {
		this.reference = reference;
		this.key = key;
	}
	
	public MapEntryRemoved(MutableVariant key) {
		this.key = key;
	}

	@Override
	public MapEntryRemoved clone(ChildReference newReference) {
		MapEntryRemoved result = new MapEntryRemoved(key);
		result.reference = newReference;
		return result;
	}	
	
	@Override
	public String toString() {
		return toRef()+" "+key+" removed";
	}	
	

}

