/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.event;

import java.io.IOException;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;

@Union({
	ArrayElementAdded.class,
	ArrayElementRemoved.class,
	MapEntryAdded.class,
	MapEntryRemoved.class,
	UnionValueAssigned.class,
	OptionalValueAssigned.class,
	OptionalValueRemoved.class,
	ValueAssigned.class,
	InvalidatedEvent.class//,
	//CustomEvent.class
})
public abstract class Event {
	
	/** Path from the listened Object to the composite, null if same */
	public @Optional ChildReference reference;
	
	/**
	 * Create a clone with new reference
	 * @param newReference
	 * @return clone with a new reference
	 */
	public abstract Event clone(ChildReference newReference);		
	
	@Override
	public String toString() {
		try {
			Binding b = Bindings.getBinding(Event.class);
			return b.printValueDefinition(this, true);
		} catch (BindingConstructionException e) {
			return e.getClass().getName()+" "+e.getMessage();
		} catch (IOException e) {
			return e.getClass().getName()+" "+e.getMessage();
		} catch (BindingException e) {
			return e.getClass().getName()+" "+e.getMessage();
		}
	}
	
	protected String toRef() {
		if (reference==null) return "[] ";
		return "["+reference+"] ";
	}
	
}

