/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.event;

import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.mutable.MutableVariant;

/**
 * TODO change to ArrayELement S Added
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class ArrayElementAdded extends ModificationEvent {
	
	public int index;
	
	/** The new element value. Value is added if the value was in interest Set */
	public @Optional MutableVariant value; 
	
	public ArrayElementAdded(ChildReference ref, int index, MutableVariant value) {
		this.reference = ref;
		this.index = index;
		this.value = value;
	}
	
	public ArrayElementAdded(int index, MutableVariant value) {
		this.index = index;
		this.value = value;
	}
	
	@Override
	public ArrayElementAdded clone(ChildReference newReference) {
		ArrayElementAdded result = new ArrayElementAdded(index, value);
		result.reference = newReference;
		return result;
	}

	@Override
	public String toString() {
		return toRef()+"["+index+"] += "+value+"";
	}
	
}

