/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor;

import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.VariantType;


public interface VariantAccessor extends Accessor {

	/**
	 * Get an accessor to the variant's content. 
	 * 
	 * @return value
	 * @throws AccessorException
	 */
	<T extends Accessor> T getContentAccessor() throws AccessorConstructionException;
	
	/**
	 * Set the content of this variant.
	 * 
	 * (Note! this methods sets the _content_ value, in contrast to 
	 * {@link Accessor#setValue(org.simantics.databoard.binding.Binding, Object)} 
	 * which sets the _variant_ value.  
	 * 
	 * @param valueBinding
	 * @param value
	 * @throws AccessorException
	 */
	void setContentValue(Binding valueBinding, Object value) throws AccessorException;
	
	/**
	 * Get the content of this variant
	 *  
	 * @param contentBinding
	 * @return content
	 * @throws AccessorException
	 */
	Object getContentValue(Binding contentBinding) throws AccessorException;
	
	/**
	 * Get the type of the content
	 * 
	 * @return type
	 * @throws AccessorException
	 */
	Datatype getContentType() throws AccessorException;
	
	/**
	 * Get the type of this variant.
	 * 
	 * @return VariantType always
	 */
	VariantType type();
	
}

