/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor;

import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.UnionType;

public interface UnionAccessor extends Accessor {
	
	/**
	 * Get the number of tag types
	 * 
	 * @return the number of tag types
	 * @throws AccessorException
	 */
	int count() throws AccessorException;
	
	/**
	 * Get the union tag index
	 * 
	 * @return tag index
	 * @throws AccessorException
	 */
	int getTag() throws AccessorException;
	
	/**
	 * Get an accessor to the component value.
	 * The accessor becomes invalid if a new value is assigned. 
	 * 
	 * @return accessor to the value
	 * @throws AccessorConstructionException 
	 */
	<T extends Accessor> T getComponentAccessor() throws AccessorConstructionException;
	
	/**
	 * Get the value
	 *  
	 * @param componentBinding component binding
	 * @return value
	 * @throws AccessorException
	 */
	Object getComponentValue(Binding componentBinding) throws AccessorException; 
	
	/**
	 * Set a new Union value.
	 * 
	 * If the tag-type changes and there is an accessor to the previous value, 
	 * it becomes invalid.
	 * 
	 * @param unionBinding
	 * @param newUnion
	 * @throws BindingException binding error
	 * @throws UnsupportedOperationException cannot set a new value
	 */
	void setValue(Binding unionBinding, Object newUnion) throws AccessorException;	
	
	/**
	 * Set a new component value. The argument newValue may be captured or copied.
	 * 
	 * @param tag
	 * @param componentBinding
	 * @param componentValue
	 * @throws AccessorException
	 */
	void setComponentValue(int tag, Binding componentBinding, Object componentValue) throws AccessorException;
	
	UnionType type();
	
}

