/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor;

import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.OptionalType;


public interface OptionalAccessor extends Accessor {

	/**
	 * Set a new value. Copies values from an Optional Value. 
	 * If existing sub-value is removed, then possibly existing accessor is 
	 * invalidated.
	 * 
	 * @param componentBinding of component type
	 * @param newComponentValue component value
	 * @throws BindingException binding error
	 * @throws UnsupportedOperationException cannot set a new value
	 */
	void setValue(Binding componentBinding, Object newComponentValue) throws AccessorException;
	
	/**
	 * Sets no value. Any existing component accessor is invalidated.
	 * 
	 * @throws AccessorException
	 */
	void setNoValue() throws AccessorException;
	
	/**
	 * Return true if there is a value assigned 
	 * 
	 * @return true if there is a value  
	 * @throws AccessorException
	 */
	boolean hasValue() throws AccessorException;

	/**
	 * Return component value if there is a component value.
	 * Exception is thrown if there is no component value.
	 * 
	 * @param componentBinding component binding
	 * @return component value 
	 * @throws AccessorException 
	 */
	Object getComponentValue(Binding componentBinding) throws AccessorException;	
	
	/**
	 * Set a new component value. Any existing component accessor is invalidated.
	 * 
	 * @param componentBinding
	 * @param componentValue
	 * @throws AccessorException
	 */
	void setComponentValue(Binding componentBinding, Object componentValue) throws AccessorException;
	
	/**
	 * Get accessor to the component value or <code>null</code> if there is no component value
	 * 
	 * @return accessor or <code>null</code>
	 * @throws AccessorConstructionException 
	 */
	<T extends Accessor> T getComponentAccessor() throws AccessorConstructionException;
	
	OptionalType type();

}

