/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard;

import org.simantics.databoard.units.ConverterCreator;
import org.simantics.databoard.units.IUnitConverter;
import org.simantics.databoard.units.IdentityConverter;
import org.simantics.databoard.units.internal.UnitParseException;
import org.simantics.databoard.units.internal.library.UnitLibrary;

public class Units {

	public static UnitLibrary library = UnitLibrary.createDefault();
	
	/**
	 * Create converter
	 * 
	 * @param sourceUnit
	 * @param targetUnit
	 * @return the converter
	 * @throws UnitParseException
	 */
	public static IUnitConverter createConverter(String sourceUnit, String targetUnit) throws UnitParseException {
		if(sourceUnit.equals(targetUnit))
			return IdentityConverter.INSTANCE;
		ConverterCreator creator = new ConverterCreator(library);
		creator.unit(sourceUnit, 1);
		creator.unit(targetUnit, -1);
		return creator.createConverter();
	}	
	
	public static double convert(double value, String sourceUnit, String targetUnit) throws UnitParseException {
		IUnitConverter c = createConverter(sourceUnit, targetUnit);
		if (c==null) throw new UnitParseException(sourceUnit+" or "+targetUnit, "could not convert");
		return c.convert(value);
	}

	
}
