/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.actions.CategorizedAction;
import org.simantics.browsing.ui.model.actions.IActionCategory;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeTypeMultiMap;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.ActionFactory2;
import org.simantics.viewpoint.ontology.ViewpointResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionContribution {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionContribution.class);
    final Resource rule;
    final NodeType nodeType;
    final Test isVisible;
    final Test isEnabled;
    final String label;
    final ActionFactory actionFactory;
    final IActionCategory category;
    final ImageDescriptor image;
    final String actionDefinitionId;

    public ActionContribution(Resource rule, NodeType nodeType, Test isVisible, Test isEnabled, String label, ActionFactory actionFactory, IActionCategory category, ImageDescriptor image, String actionDefinitionId) {
        this.rule = rule;
        this.nodeType = nodeType;
        this.isVisible = isVisible;
        this.isEnabled = isEnabled;
        this.label = label;
        this.actionFactory = actionFactory;
        this.category = category;
        this.image = image;
        this.actionDefinitionId = actionDefinitionId;
    }

    public static void load(ReadGraph g, Resource r, NodeTypeMultiMap<ActionContribution> contributions) throws DatabaseException {
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        Resource isVisibleResource = g.getPossibleObject(r, vr.ActionContribution_IsVisibleIf);
        Test isVisible = isVisibleResource == null ? null : (Test)g.adapt(isVisibleResource, Test.class);
        Resource isEnabledResource = g.getPossibleObject(r, vr.ActionContribution_IsEnabledIf);
        Test isEnabled = isEnabledResource == null ? null : (Test)g.adapt(isEnabledResource, Test.class);
        String label = NameUtils.getSafeLabel((ReadGraph)g, (Resource)r);
        ActionFactory actionFactory = (ActionFactory)g.adapt(g.getSingleObject(r, vr.ActionContribution_HasAction), ActionFactory.class);
        Resource categoryResource = g.getPossibleObject(r, vr.ActionContribution_HasCategory);
        IActionCategory category = categoryResource == null ? null : (IActionCategory)g.adapt(categoryResource, IActionCategory.class);
        Resource imageResource = g.getPossibleObject(r, vr.ActionContribution_HasImage);
        ImageDescriptor image = imageResource == null ? null : (ImageDescriptor)g.adapt(imageResource, ImageDescriptor.class);
        String actionDefinitionId = (String)g.getPossibleRelatedValue(r, vr.ActionContribution_HasActionDefinitionId, (Binding)Bindings.STRING);
        for (Resource nodeTypeResource : g.getObjects(r, vr.ActionContribution_HasNodeType)) {
            NodeType nodeType = (NodeType)g.adapt(nodeTypeResource, NodeType.class);
            ActionContribution contribution = new ActionContribution(r, nodeType, isVisible, isEnabled, label, actionFactory, category, image, actionDefinitionId);
            contributions.put(nodeType, contribution);
        }
    }

    public CategorizedAction getAction(ReadGraph graph, NodeContext context, Collection<NodeContext> all) {
        block5: {
            Runnable runnable;
            Object content;
            block6: {
                content = context.getConstant(BuiltinKeys.INPUT);
                try {
                    if (this.isVisible != null && !this.isVisible.test(graph, content)) break block5;
                    ArrayList<Object> allContents = new ArrayList<Object>();
                    for (NodeContext ctx : all) {
                        allContents.add(ctx.getConstant(BuiltinKeys.INPUT));
                    }
                    Runnable runnable2 = runnable = this.actionFactory instanceof ActionFactory2 ? ((ActionFactory2)this.actionFactory).create(allContents) : this.actionFactory.create(content);
                    if (runnable != null) break block6;
                    return null;
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to get CategorizedAction", (Throwable)e);
                    return null;
                }
            }
            ActionContributionAction action = new ActionContributionAction(this.label, this.rule, runnable);
            action.setId(runnable.getClass().getName());
            action.setEnabled(this.isEnabled == null || this.isEnabled.test(graph, content));
            action.setActionDefinitionId(this.actionDefinitionId);
            if (this.image != null) {
                action.setImageDescriptor(this.image);
            }
            return new CategorizedAction(action, this.category);
        }
        return null;
    }

    public static class ActionContributionAction
    extends Action {
        public Resource contribution;
        public Runnable runnable;

        public ActionContributionAction(String label, Resource rule, Runnable runnable) {
            super(label);
            this.contribution = rule;
            this.runnable = runnable;
        }

        public void run() {
            this.runnable.run();
        }
    }
}

