/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleVariable;
import org.simantics.db.layer0.request.PossibleVariableRepresents;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.ExplorerInputContentType;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardWorkbenchSelectionElement
extends AdaptableHintContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardWorkbenchSelectionElement.class);
    public final WorkbenchSelectionElement wse;
    public final Object content;
    public final Resource resource;
    public final Variable variable;
    public final Object input;

    public static WorkbenchSelectionElement nodeContextToWorkbenchSelectionElement(NodeContext context) {
        return new StandardWorkbenchSelectionElement(context);
    }

    /*
     * WARNING - void declaration
     */
    private WorkbenchSelectionElement extractWse(Object content) {
        Object object = content;
        if (object instanceof NodeContext) {
            void context;
            Object input;
            NodeContext nodeContext = (NodeContext)object;
            NodeContext cfr_ignored_0 = (NodeContext)object;
            Object object2 = input = context.getConstant(NodeType.TYPE);
            if (object2 instanceof NodeType) {
                void nt;
                NodeType nodeType = (NodeType)object2;
                NodeType cfr_ignored_1 = (NodeType)object2;
                return nt.getWorkbenchSelectionElement((NodeContext)context);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Resource extractResource(Object content) {
        Object object = content;
        if (object instanceof Resource) {
            void r;
            Resource resource = (Resource)object;
            Resource cfr_ignored_0 = (Resource)object;
            return r;
        }
        Object object2 = content;
        if (object2 instanceof NodeContext) {
            void context;
            Object input;
            NodeContext nodeContext = (NodeContext)object2;
            NodeContext cfr_ignored_1 = (NodeContext)object2;
            Object object3 = input = context.getConstant(BuiltinKeys.INPUT);
            if (object3 instanceof Resource) {
                void r;
                Resource resource = (Resource)object3;
                Resource cfr_ignored_2 = (Resource)object3;
                return r;
            }
            Object object4 = input;
            if (object4 instanceof IAdaptable) {
                void a;
                IAdaptable iAdaptable = (IAdaptable)object4;
                IAdaptable cfr_ignored_3 = (IAdaptable)object4;
                Resource var = (Resource)a.getAdapter(Resource.class);
                if (var != null) {
                    return var;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Variable extractVariable(Object content) {
        Object object = content;
        if (object instanceof Variable) {
            void v;
            Variable variable = (Variable)object;
            Variable cfr_ignored_0 = (Variable)object;
            return v;
        }
        Object object2 = content;
        if (object2 instanceof NodeContext) {
            void context;
            Object input;
            NodeContext nodeContext = (NodeContext)object2;
            NodeContext cfr_ignored_1 = (NodeContext)object2;
            Object object3 = input = context.getConstant(BuiltinKeys.INPUT);
            if (object3 instanceof Variable) {
                void v;
                Variable variable = (Variable)object3;
                Variable cfr_ignored_2 = (Variable)object3;
                return v;
            }
            Object object4 = input;
            if (object4 instanceof IAdaptable) {
                void a;
                IAdaptable iAdaptable = (IAdaptable)object4;
                IAdaptable cfr_ignored_3 = (IAdaptable)object4;
                Variable var = (Variable)a.getAdapter(Variable.class);
                if (var != null) {
                    return var;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Object extractInput(Object content) {
        Object object = content;
        if (object instanceof NodeContext) {
            void context;
            NodeContext nodeContext = (NodeContext)object;
            NodeContext cfr_ignored_0 = (NodeContext)object;
            return context.getConstant(BuiltinKeys.INPUT);
        }
        return null;
    }

    public StandardWorkbenchSelectionElement(Object content) {
        super(new IHintContext.Key[0]);
        this.content = content;
        this.wse = this.extractWse(content);
        this.resource = this.extractResource(content);
        this.variable = this.extractVariable(content);
        this.input = this.extractInput(content);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
        Object result;
        if (this.wse != null && (result = this.wse.getContent(contentType)) != null) {
            return (T)result;
        }
        WorkbenchSelectionContentType<T> workbenchSelectionContentType = contentType;
        if (workbenchSelectionContentType instanceof AnyResource) {
            result = (AnyResource)workbenchSelectionContentType;
            AnyResource cfr_ignored_0 = (AnyResource)workbenchSelectionContentType;
            if (this.resource != null) {
                return (T)this.resource;
            }
            if (this.variable == null) {
                return null;
            }
            try {
                void ar;
                return (T)ar.processor.syncRequest((Read)new PossibleVariableRepresents(this.variable));
            }
            catch (DatabaseException e) {
                LOGGER.error("Unexpected error occurred while resolving Resource from Variable " + String.valueOf(this.variable), (Throwable)e);
            }
        } else {
            WorkbenchSelectionContentType<T> workbenchSelectionContentType2 = contentType;
            if (workbenchSelectionContentType2 instanceof AnyVariable) {
                AnyVariable e = (AnyVariable)workbenchSelectionContentType2;
                AnyVariable cfr_ignored_1 = (AnyVariable)workbenchSelectionContentType2;
                if (this.variable != null) {
                    return (T)this.variable;
                }
                if (this.resource == null) {
                    return null;
                }
                try {
                    void av;
                    return (T)av.processor.syncRequest((Read)new PossibleVariable(this.resource));
                }
                catch (DatabaseException e2) {
                    LOGGER.error("Unexpected error occurred while resolving Variable from Resource " + String.valueOf(this.resource), (Throwable)e2);
                }
            } else if (contentType instanceof ExplorerInputContentType) {
                return (T)this.input;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object getAdapter(Class adapter) {
        if (WorkbenchSelectionElement.class == adapter) {
            return this.wse;
        }
        if (NodeContext.class == adapter) {
            Object object = this.content;
            if (object instanceof NodeContext) {
                void context;
                NodeContext nodeContext = (NodeContext)object;
                NodeContext cfr_ignored_0 = (NodeContext)object;
                return context;
            }
            return null;
        }
        return super.getAdapter(adapter);
    }
}

