/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.labels;

import java.util.Collections;
import java.util.Map;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;

public class ResourceLabelLabelRule implements LabelRule {
    public static final ResourceLabelLabelRule INSTANCE = new ResourceLabelLabelRule();
    
    public ResourceLabelLabelRule() {
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Map<String,String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        String label = NameUtils.getSafeLabel(graph, (Resource) content);
        // FIXME: this is a hack to cover for cases where an empty HasLabel is
        // asserted for the content in order to make the property editable in the
        // property view.
        if (label.isEmpty())
            label = NameUtils.getSafeName(graph, (Resource) content);
        return Collections.singletonMap(ColumnKeys.SINGLE, label); 
    }
}
