/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import fi.vtt.simantics.procore.internal.Serialization;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.simantics.acorn.AcornKey;
import org.simantics.acorn.HeadState;
import org.simantics.acorn.Store;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainState
implements Serializable {
    private static final long serialVersionUID = 6237383147637270225L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MainState.class);
    public static final String MAIN_STATE = "main.state";
    public int headDir;
    private static final Binding BINDING = Bindings.getBindingUnchecked(MainState.class);
    private static final DateTimeFormatter RECOVERY_DIR_FORMAT = DateTimeFormatter.ofPattern("yyyy-M-d_HH-mm-ss");

    public MainState() {
        this.headDir = 0;
    }

    private MainState(int headDir) {
        this.headDir = headDir;
    }

    public boolean isInitial() {
        return this.headDir == 0;
    }

    public static MainState load(Store store, Runnable rollbackCallback) throws IOException {
        store.ensureExists();
        AcornKey mainState = store.rootKey(MAIN_STATE);
        try {
            int latestRevision;
            block13: {
                byte[] mainStateValue = mainState.bytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(mainStateValue);
                MainState state = (MainState)Files.readFile((InputStream)bais, (Binding)Bindings.getBindingUnchecked(MainState.class));
                bais.close();
                latestRevision = state.headDir - 1;
                try {
                    AcornKey latest = store.rootKey(Integer.toString(latestRevision));
                    if (!HeadState.validateHeadStateIntegrity(latest.child("head.state"))) break block13;
                    MainState.archiveRevisionDirectories(store, latestRevision, rollbackCallback);
                    MainState mainState2 = state;
                    return mainState2;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOGGER.warn("Failed to start database from revision " + latestRevision + " stored in " + String.valueOf(mainState) + ". Revision does not contain head.state.");
                    MainState mainState3 = MainState.rollback(store, rollbackCallback);
                    return mainState3;
                }
            }
            LOGGER.warn("Failed to start database from revision " + latestRevision + " stored in " + String.valueOf(mainState) + ". head.state is invalid.");
            MainState mainState4 = MainState.rollback(store, rollbackCallback);
            return mainState4;
        }
        catch (IOException iOException) {
            if (MainState.listRevisionDirs(store, true, MainState::isInteger).isEmpty()) {
                MainState mainState5 = new MainState(0);
                return mainState5;
            }
            LOGGER.warn("Unclean exit detected, " + String.valueOf(mainState) + " not found. Initiating automatic rollback.");
            MainState mainState6 = MainState.rollback(store, rollbackCallback);
            return mainState6;
        }
        catch (Exception e) {
            LOGGER.warn("Unclean exit detected. Initiating automatic rollback.", (Throwable)e);
            MainState mainState7 = MainState.rollback(store, rollbackCallback);
            return mainState7;
        }
        finally {
            mainState.deleteIfExists();
        }
    }

    private static MainState rollback(Store directory, Runnable rollbackCallback) throws IOException {
        LOGGER.warn("Database rollback initiated for " + String.valueOf(directory));
        rollbackCallback.run();
        AcornKey latest = MainState.findNewHeadStateDir(directory);
        int latestRevision = latest != null ? MainState.safeParseInt(-1, latest) : -1;
        MainState state = new MainState(latestRevision + 1);
        MainState.archiveRevisionDirectories(directory, latestRevision, rollbackCallback);
        LOGGER.warn("Database rollback completed. Restarting database from revision " + String.valueOf(latest));
        return state;
    }

    private byte[] toByteArray() throws IOException {
        return Serialization.toByteArray((int)4096, (Binding)BINDING, (Object)this);
    }

    public void save(Store store) throws IOException {
        byte[] bytes = this.toByteArray();
        IO io = store.rootKey(MAIN_STATE).getIO();
        io.saveBytes(bytes, bytes.length, true);
    }

    private static int safeParseInt(int defaultValue, AcornKey p) {
        try {
            return Integer.parseInt(p.getName());
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private static boolean isInteger(AcornKey p) {
        return MainState.safeParseInt(Integer.MIN_VALUE, p) != Integer.MIN_VALUE;
    }

    private static Predicate<AcornKey> isInteger() {
        return p -> MainState.isInteger(p);
    }

    private static Predicate<AcornKey> isGreaterThan(int i) {
        return p -> {
            int pi = MainState.safeParseInt(Integer.MIN_VALUE, p);
            return pi != Integer.MIN_VALUE && pi > i;
        };
    }

    private static AcornKey findNewHeadStateDir(Store store) throws IOException {
        List<AcornKey> dirs = MainState.listRevisionDirs(store, true, MainState.isInteger());
        for (AcornKey last : dirs) {
            if (!HeadState.validateHeadStateIntegrity(last.child("head.state"))) continue;
            return last;
        }
        return null;
    }

    private static void archiveRevisionDirectories(Store store, int greaterThanRevision, Runnable rollbackCallback) throws IOException {
        List<AcornKey> reverseSortedPaths = MainState.listRevisionDirs(store, true, MainState.isGreaterThan(greaterThanRevision));
        if (reverseSortedPaths.isEmpty()) {
            return;
        }
        if (!MainState.anyContainsHeadState(reverseSortedPaths)) {
            for (AcornKey p : reverseSortedPaths) {
                MainState.deleteAll(p);
                LOGGER.info("Removed useless working folder " + String.valueOf(p));
            }
            return;
        }
        rollbackCallback.run();
        AcornKey recoveryFolder = MainState.getRecoveryFolder(store);
        recoveryFolder.ensureExists();
        LOGGER.info("Created new database recovery folder " + String.valueOf(recoveryFolder));
        for (AcornKey p : reverseSortedPaths) {
            AcornKey to = recoveryFolder.child(p.getName());
            p.copyTo(to);
            LOGGER.info("Archived revision " + String.valueOf(p) + " in recovery folder " + String.valueOf(recoveryFolder));
        }
    }

    private static boolean anyContainsHeadState(List<AcornKey> paths) throws IOException {
        for (AcornKey p : paths) {
            if (!p.child("head.state").exists()) continue;
            return true;
        }
        return false;
    }

    private static void deleteAll(AcornKey dir) throws IOException {
        dir.deleteAll();
    }

    private static AcornKey getRecoveryFolder(Store store) throws IOException {
        return MainState.findNonexistentDir(store.rootKey("recovery"), RECOVERY_DIR_FORMAT.format(ZonedDateTime.now()));
    }

    private static AcornKey findNonexistentDir(AcornKey inDirectory, String prefix) throws IOException {
        int i = 0;
        AcornKey dir;
        while ((dir = inDirectory.child((String)(i == 0 ? prefix : prefix + "-" + i))).exists()) {
            ++i;
        }
        return dir;
    }

    @SafeVarargs
    private static final List<AcornKey> listRevisionDirs(Store store, boolean descending, Predicate<AcornKey> ... filters) throws IOException {
        int coef = descending ? -1 : 1;
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<AcornKey> dirs = store.directories();){
            Stream<AcornKey> fs = dirs;
            Predicate<AcornKey>[] predicateArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                Predicate<AcornKey> p = predicateArray[n2];
                fs = fs.filter(p);
                ++n2;
            }
            return fs.sorted((p1, p2) -> coef * Integer.compare(Integer.parseInt(p1.getName()), Integer.parseInt(p2.getName()))).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

