/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.GraphClientImpl2;
import org.simantics.acorn.OperationQueue;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.lru.ClusterStreamChunk;
import org.simantics.acorn.lru.ClusterUpdateOperation;
import org.simantics.db.service.ClusterUID;
import org.simantics.utils.logging.TimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainProgram
implements Runnable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainProgram.class);
    private static final int CLUSTER_THREADS = 4;
    private static final int CHUNK_CACHE_SIZE = 100;
    private final GraphClientImpl2 client;
    private final ExecutorService[] clusterUpdateThreads;
    private final List<ClusterUpdateOperation>[] updateSchedules;
    private Thread mainProgramThread;
    private boolean alive = true;
    private Semaphore deathBarrier = new Semaphore(0);
    final ClusterManager clusters;
    private final OperationQueue operationQueue = new OperationQueue(this);
    private static Comparator<ClusterUID> clusterComparator = new Comparator<ClusterUID>(){

        @Override
        public int compare(ClusterUID o1, ClusterUID o2) {
            return Long.compare(o1.second, o2.second);
        }
    };

    MainProgram(GraphClientImpl2 client, ClusterManager clusters) {
        this.client = client;
        this.clusters = clusters;
        this.clusterUpdateThreads = new ExecutorService[4];
        this.updateSchedules = new ArrayList[4];
        int i = 0;
        while (i < this.clusterUpdateThreads.length) {
            this.clusterUpdateThreads[i] = Executors.newSingleThreadExecutor(new ClusterThreadFactory("Cluster Updater " + (i + 1), false));
            this.updateSchedules[i] = new ArrayList<ClusterUpdateOperation>();
            ++i;
        }
    }

    void startTransaction(long id) {
        this.operationQueue.startTransaction(id);
    }

    @Override
    public void run() {
        this.mainProgramThread = Thread.currentThread();
        try {
            try {
                TreeMap<ClusterUID, List<ClusterUpdateOperation>> updates = new TreeMap<ClusterUID, List<ClusterUpdateOperation>>(clusterComparator);
                while (this.alive) {
                    block21: {
                        if (!updates.isEmpty()) {
                            updates.clear();
                        }
                        this.operationQueue.pumpUpdates(updates);
                        if (updates.isEmpty()) {
                            long duration = this.operationQueue.waitFor();
                            if (!this.alive) {
                                break;
                            }
                            if (duration > 4000000000L) {
                                this.checkIdle();
                            }
                        }
                        this.runUpdates(updates);
                        this.runTasksIfEmpty();
                        this.clusters.streamLRU.acquireMutex();
                        try {
                            try {
                                this.swapChunks();
                            }
                            catch (AcornAccessVerificationException | IllegalAcornStateException e) {
                                LOGGER.error("cluster chunk swapping failed", (Throwable)e);
                                this.clusters.streamLRU.releaseMutex();
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            this.clusters.streamLRU.releaseMutex();
                            throw throwable;
                        }
                        this.clusters.streamLRU.releaseMutex();
                    }
                    this.clusters.csLRU.acquireMutex();
                    try {
                        try {
                            this.swapCS();
                        }
                        catch (Throwable t) {
                            throw new IllegalAcornStateException(t);
                        }
                    }
                    finally {
                        this.clusters.csLRU.releaseMutex();
                    }
                    TimeLogger.log((String)"Performed updates");
                }
            }
            catch (Throwable t) {
                LOGGER.error("FATAL: MainProgram died unexpectedly", t);
                this.deathBarrier.release();
            }
        }
        finally {
            this.deathBarrier.release();
        }
    }

    private void runUpdates(TreeMap<ClusterUID, List<ClusterUpdateOperation>> updates) throws InterruptedException {
        int i = 0;
        while (i < 4) {
            this.updateSchedules[i].clear();
            ++i;
        }
        if (updates.isEmpty()) {
            return;
        }
        final Semaphore s = new Semaphore(0);
        for (Map.Entry<ClusterUID, List<ClusterUpdateOperation>> entry : updates.entrySet()) {
            ClusterUID key = entry.getKey();
            int hash = key.hashCode() & this.clusterUpdateThreads.length - 1;
            this.updateSchedules[hash].addAll((Collection<ClusterUpdateOperation>)entry.getValue());
        }
        int acquireAmount = 0;
        int i2 = 0;
        while (i2 < 4) {
            final List<ClusterUpdateOperation> ops = this.updateSchedules[i2];
            if (!ops.isEmpty()) {
                ++acquireAmount;
                this.clusterUpdateThreads[i2].submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try {
                            for (ClusterUpdateOperation op : ops) {
                                op.run();
                            }
                        }
                        finally {
                            s.release();
                        }
                        return null;
                    }
                });
            }
            ++i2;
        }
        s.acquire(acquireAmount);
    }

    private void runTasksIfEmpty() {
        if (this.operationQueue.isEmpty()) {
            ArrayList<MainProgramRunnable> todo = new ArrayList<MainProgramRunnable>();
            this.operationQueue.pumpTasks(todo);
            for (MainProgramRunnable runnable : todo) {
                try {
                    runnable.run();
                    runnable.success();
                }
                catch (Exception e) {
                    runnable.error(e);
                }
            }
        }
    }

    private void checkIdle() throws IOException, IllegalAcornStateException, AcornAccessVerificationException {
        if (this.operationQueue.isEmpty()) {
            boolean written = this.clusters.csLRU.swapForced();
            while (written) {
                if (!this.operationQueue.isEmpty()) break;
                written = this.clusters.csLRU.swapForced();
            }
            written = this.clusters.streamLRU.swapForced();
            while (written) {
                if (!this.operationQueue.isEmpty()) break;
                written = this.clusters.streamLRU.swapForced();
            }
            written = this.clusters.fileLRU.swapForced();
            while (written) {
                if (!this.operationQueue.isEmpty()) break;
                written = this.clusters.fileLRU.swapForced();
            }
            written = this.clusters.clusterLRU.swapForced();
            while (written) {
                if (!this.operationQueue.isEmpty()) break;
                written = this.clusters.clusterLRU.swapForced();
            }
            this.client.tryMakeSnapshot();
        }
    }

    void runIdle(MainProgramRunnable task) {
        this.operationQueue.scheduleTask(task);
    }

    private void swapChunks() throws AcornAccessVerificationException, IllegalAcornStateException {
        while (this.clusters.streamLRU.swap(Long.MAX_VALUE, 100)) {
        }
    }

    private void swapCS() throws AcornAccessVerificationException, IllegalAcornStateException {
        while (this.clusters.csLRU.swap(Long.MAX_VALUE, 100)) {
        }
    }

    void committed() {
        ClusterStreamChunk last = this.operationQueue.commitLast();
        if (!this.alive) {
            LOGGER.error("Trying to commit operation after MainProgram is closed! Operation is " + String.valueOf(last));
        }
    }

    void schedule(ClusterUpdateOperation operation) throws IllegalAcornStateException {
        if (!this.alive) {
            LOGGER.error("Trying to schedule operation after MainProgram is closed! Operation is " + String.valueOf(operation));
        }
        this.clusters.streamLRU.acquireMutex();
        try {
            try {
                this.operationQueue.scheduleUpdate(operation);
                this.swapChunks();
            }
            catch (IllegalAcornStateException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IllegalAcornStateException(t);
            }
        }
        finally {
            this.clusters.streamLRU.releaseMutex();
        }
    }

    @Override
    public void close() {
        this.alive = false;
        this.operationQueue.scheduleTask(() -> {});
        try {
            this.deathBarrier.acquire();
        }
        catch (InterruptedException interruptedException) {}
        ExecutorService[] executorServiceArray = this.clusterUpdateThreads;
        int n = this.clusterUpdateThreads.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutorService executor = executorServiceArray[n2];
            executor.shutdown();
            ++n2;
        }
        int i = 0;
        while (i < this.clusterUpdateThreads.length) {
            try {
                ExecutorService executor = this.clusterUpdateThreads[i];
                executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
                this.clusterUpdateThreads[i] = null;
            }
            catch (InterruptedException e) {
                LOGGER.error("clusterUpdateThread[{}] termination interrupted", (Object)i, (Object)e);
            }
            ++i;
        }
    }

    void assertMainProgramThread() {
        assert (Thread.currentThread().equals(this.mainProgramThread));
    }

    void assertNoMainProgramThread() {
        assert (!Thread.currentThread().equals(this.mainProgramThread));
    }

    static class ClusterThreadFactory
    implements ThreadFactory {
        final String name;
        final boolean daemon;

        public ClusterThreadFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.name);
            thread.setDaemon(this.daemon);
            return thread;
        }
    }

    @FunctionalInterface
    static interface MainProgramRunnable {
        public void run() throws Exception;

        default public void error(Exception e) {
            LOGGER.error("An error occured", (Throwable)e);
        }

        default public void success() {
        }
    }
}

