/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.lru;

import java.util.concurrent.Semaphore;
import org.simantics.db.service.ClusterUID;

public class ClusterUpdateState {
    final ClusterUID uid;
    final Semaphore lock = new Semaphore(0);
    int referenceCount = 0;
    boolean inUpdate = false;

    ClusterUpdateState(ClusterUID uid) {
        this.uid = uid;
    }

    public void waitForUpdates() {
        try {
            this.lock.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void beginUpdate() {
        assert (!this.inUpdate);
        this.inUpdate = true;
    }

    public synchronized void endUpdate() {
        assert (this.inUpdate);
        this.inUpdate = false;
    }

    public synchronized void incRef() {
        ++this.referenceCount;
    }

    public synchronized ClusterUpdateState decRef() {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            this.lock.release(Integer.MAX_VALUE);
            return null;
        }
        return this;
    }
}

