/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.internal;

import gnu.trove.map.hash.TIntByteHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.simantics.acorn.internal.Change;
import org.simantics.acorn.internal.ClusterStream;
import org.simantics.compressions.Compressions;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.ClusterTraitsSmall;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.ClusterUID;
import org.simantics.utils.datastructures.Pair;

public final class ClusterChange {
    public static final int VERSION = 1;
    public static final byte ADD_OPERATION = 2;
    public static final byte REMOVE_OPERATION = 3;
    public static final byte DELETE_OPERATION = 5;
    public static final boolean DEBUG = false;
    public static final boolean DEBUG_STAT = false;
    public static final boolean DEBUG_CCS = false;
    private static ClusterStream.DebugInfo sum = new ClusterStream.DebugInfo();
    public final TIntByteHashMap foreignTable = new TIntByteHashMap();
    private final ClusterStream.DebugInfo info;
    public final ClusterUID clusterUID;
    private final int SIZE_OFFSET;
    public static final int MAX_FIXED_BYTES = 49152;
    private static final int MAX_FIXED_OPERATION_SIZE = 33;
    private static final int MAX_FIXED_OPERATION_SIZE_AND_ROOM_FOR_ERROR = 69;
    private int nextSize = 49152;
    int byteIndex = 0;
    private byte[] bytes = null;
    private boolean flushed = false;
    private ArrayList<Pair<ClusterUID, byte[]>> stream;
    private List<DebugStm> debugStms = new ArrayList<DebugStm>();

    public ClusterChange(ArrayList<Pair<ClusterUID, byte[]>> stream, ClusterUID clusterUID) {
        this.clusterUID = clusterUID;
        long[] longs = new long[ClusterUID.getLongLength()];
        clusterUID.toLong(longs, 0);
        this.stream = stream;
        this.info = new ClusterStream.DebugInfo();
        this.SIZE_OFFSET = 0;
    }

    public String toString() {
        return super.toString() + " cluster=" + String.valueOf(this.clusterUID) + " off=" + this.byteIndex;
    }

    public final void initBuffer() {
        this.flushed = false;
        if (this.bytes == null || this.bytes.length < this.nextSize) {
            this.bytes = new byte[this.nextSize];
            this.nextSize = 49152;
        }
        this.byteIndex = 0;
    }

    private final void clear() {
        this.foreignTable.clear();
        this.bytes = null;
        this.byteIndex = 0;
    }

    private final void checkInitialization() {
    }

    private final void printlnd(String s) {
        System.out.println("DEBUG: ClusterChange " + String.valueOf(this.clusterUID) + ": " + s);
    }

    public final void createResource(short index) {
        this.checkInitialization();
        if (index > ClusterTraits.getMaxNumberOfResources()) {
            throw new RuntimeDatabaseException("Illegal resource index=" + index + ".");
        }
        this.checkBufferSpace(null);
        this.bytes[this.byteIndex++] = 52;
        this.bytes[this.byteIndex++] = (byte)index;
        this.bytes[this.byteIndex++] = (byte)(index >>> 8);
    }

    void flushCollect(Change c) {
        throw new UnsupportedOperationException();
    }

    private final boolean checkBufferSpace(Change c) {
        if (this.bytes == null) {
            this.initBuffer();
        }
        if (49152 - this.byteIndex > 69) {
            return false;
        }
        this.flush();
        return true;
    }

    private final void checkBufferSpace(int size) {
        if (this.bytes == null) {
            this.initBuffer();
        }
        if (this.bytes.length - this.byteIndex >= size) {
            return;
        }
        this.nextSize = Math.max(49152, size);
        this.flush();
        this.initBuffer();
    }

    public final void addChange(Change c) {
        this.checkInitialization();
        this.checkBufferSpace(c);
        byte operation = c.op0;
        if (operation == 2) {
            this.addStm(c, ClusterStream.StmEnum.Add);
        } else if (operation == 3) {
            this.addStm(c, ClusterStream.StmEnum.Remove);
        } else if (operation == 5) {
            this.addByte(ClusterStream.OpEnum.Delete.getOrMask());
            this.addShort(ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)c.key0));
        }
        c.lastArg = 0;
    }

    private final void addForeignLong(short index, ClusterUID clusterUID) {
        this.byteIndex = clusterUID.toByte(this.bytes, this.byteIndex);
        this.bytes[this.byteIndex++] = (byte)(index & 0xFF);
        this.bytes[this.byteIndex++] = (byte)(index >>> 8);
    }

    private final ClusterStream.ClusterEnum addIndexAndCluster(int key, ClusterUID clusterUID, byte lookIndex, byte[] lookup) {
        assert (!clusterUID.equals((Object)ClusterUID.Null));
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)key);
        if (clusterUID.equals((Object)this.clusterUID)) {
            this.bytes[this.byteIndex++] = (byte)(resourceIndex & 0xFF);
            this.bytes[this.byteIndex++] = (byte)(resourceIndex >>> 8);
            return ClusterStream.ClusterEnum.Local;
        }
        byte foreign = 0;
        if (lookIndex > 0) {
            if (lookup != null) {
                foreign = lookup[lookIndex];
            }
        } else {
            foreign = this.foreignTable.get(key);
        }
        if (foreign != 0) {
            if (foreign > 256) {
                throw new RuntimeDatabaseException("Internal error.Too big foreing index=" + foreign + " max=256");
            }
            foreign = (byte)(foreign - 1);
            this.bytes[this.byteIndex++] = foreign;
            return ClusterStream.ClusterEnum.ForeignShort;
        }
        byte position = (byte)(this.foreignTable.size() + 1);
        if (lookup != null) {
            lookup[lookIndex] = position;
        }
        this.foreignTable.put(key, position);
        if (clusterUID.equals((Object)ClusterUID.Null)) {
            throw new RuntimeDatabaseException("Internal error.Cluster unique id not defined for foreing cluster.");
        }
        this.addForeignLong(resourceIndex, clusterUID);
        return ClusterStream.ClusterEnum.ForeignLong;
    }

    private final void addByte(byte b) {
        this.bytes[this.byteIndex++] = b;
    }

    private final void addShort(short s) {
        this.bytes[this.byteIndex++] = (byte)(s & 0xFF);
        this.bytes[this.byteIndex++] = (byte)(s >>> 8);
    }

    private final void addInt(int i) {
        this.bytes[this.byteIndex++] = (byte)(i & 0xFF);
        this.bytes[this.byteIndex++] = (byte)(i >>> 8 & 0xFF);
        this.bytes[this.byteIndex++] = (byte)(i >>> 16 & 0xFF);
        this.bytes[this.byteIndex++] = (byte)(i >>> 24 & 0xFF);
    }

    private void addLong7(long l) {
        this.bytes[this.byteIndex++] = (byte)(l & 0xFFL);
        this.bytes[this.byteIndex++] = (byte)(l >>> 8 & 0xFFL);
        this.bytes[this.byteIndex++] = (byte)(l >>> 16 & 0xFFL);
        this.bytes[this.byteIndex++] = (byte)(l >>> 24 & 0xFFL);
        this.bytes[this.byteIndex++] = (byte)(l >>> 32 & 0xFFL);
        this.bytes[this.byteIndex++] = (byte)(l >>> 40 & 0xFFL);
        this.bytes[this.byteIndex++] = (byte)(l >>> 48 & 0xFFL);
    }

    private final byte bufferPop() {
        return this.bytes[--this.byteIndex];
    }

    private final void addStm(Change c, ClusterStream.StmEnum stmEnum) {
        int ri;
        int opPos = this.byteIndex++;
        boolean done = true;
        ClusterStream.ClusterEnum a = this.addIndexAndCluster(c.key1, c.clusterUID1, c.lookIndex1, c.lookup1);
        byte ab = 0;
        if (a != ClusterStream.ClusterEnum.ForeignShort) {
            ab = this.bufferPop();
            done = false;
        }
        ClusterStream.ClusterEnum b = this.addIndexAndCluster(c.key2, c.clusterUID2, c.lookIndex2, c.lookup2);
        byte bb = 0;
        if (b != ClusterStream.ClusterEnum.ForeignShort) {
            bb = this.bufferPop();
            done = false;
        }
        if (ClusterTraitsSmall.isIllegalResourceIndex((int)(ri = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)c.key0)))) {
            throw new RuntimeDatabaseException("Assertion error. Illegal resource index=" + ri);
        }
        this.bytes[this.byteIndex++] = (byte)ri;
        if (!done) {
            ClusterStream.Data data = ClusterStream.ClusterEnum.getData(stmEnum, a, b);
            int left = 6 - data.bits;
            int op = ri >>> 8 + left;
            ri >>>= 8;
            ri &= (1 << left) - 1;
            if (a != ClusterStream.ClusterEnum.ForeignShort) {
                ri |= ab << left;
                left += 6;
            }
            if (b != ClusterStream.ClusterEnum.ForeignShort) {
                ri |= bb << left;
                left += 6;
            }
            switch (data.bytes) {
                default: {
                    throw new RuntimeDatabaseException("Assertion error. Illegal number of bytes=" + data.bytes);
                }
                case 2: {
                    this.bytes[this.byteIndex++] = (byte)(ri & 0xFF);
                    this.bytes[this.byteIndex++] = (byte)(ri >>> 8 & 0xFF);
                    break;
                }
                case 1: {
                    this.bytes[this.byteIndex++] = (byte)(ri & 0xFF);
                }
                case 0: 
            }
            this.bytes[opPos] = (byte)(op |= data.mask);
        } else {
            this.bytes[opPos] = stmEnum == ClusterStream.StmEnum.Add ? (byte)((ri >>> 8) + 64) : (byte)((ri >>> 8) + 128);
        }
        if (this.foreignTable.size() > 252) {
            this.flush();
        }
    }

    private final int modiValue(int ri, long value_offset, byte[] bytes, int offset, int size) {
        if (ClusterTraitsBase.isIllegalResourceIndex((int)ri)) {
            throw new RuntimeDatabaseException("Assertion error. Illegal resource index=" + ri);
        }
        if (value_offset > 0x200000000000000L) {
            throw new RuntimeDatabaseException("Illegal value offset=" + value_offset);
        }
        if (size < 0 || size > 49151) {
            throw new RuntimeDatabaseException("Illegal value size=" + size);
        }
        if (offset + size > bytes.length) {
            throw new RuntimeDatabaseException("Illegal value size=" + size);
        }
        this.checkBufferSpace(12 + size);
        this.addByte(ClusterStream.OpEnum.Modify.getOrMask());
        ri = (int)((long)ri | value_offset >>> 56 << 14);
        this.addShort((short)ri);
        this.addLong7(value_offset &= 0xFFFFFFFFFFFFFFL);
        this.addShort((short)size);
        int copied = Math.min(size, this.bytes.length - this.byteIndex);
        System.arraycopy(bytes, offset, this.bytes, this.byteIndex, copied);
        this.byteIndex += size;
        return copied;
    }

    private final int setValueBig(int ri, byte[] bytes, int length_) {
        this.checkBufferSpace(12);
        int sum = 0;
        int voffset = 0;
        int offset = 0;
        int left = length_;
        while (left > 0) {
            int length = Math.min(left, 49140 - this.byteIndex);
            int written = this.modiValue(ri, voffset, bytes, offset, length);
            sum += written;
            voffset += written;
            offset += written;
            left -= written;
            this.checkBufferSpace(12);
        }
        return sum;
    }

    private final int setValueSmall(int ri, byte[] bytes, int length) {
        this.checkBufferSpace(5 + length);
        int pos = this.byteIndex;
        int i = length << 14 | ri;
        if (length < 32) {
            byte op = (byte)(ClusterStream.OpEnum.SetShort.getOrMask() | length >>> 2);
            this.addByte(op);
            short s = (short)i;
            this.addShort(s);
        } else {
            this.addByte(ClusterStream.OpEnum.Set.getOrMask());
            this.addInt(i);
        }
        System.arraycopy(bytes, 0, this.bytes, this.byteIndex, length);
        this.byteIndex += length;
        int len = this.byteIndex - pos;
        return len;
    }

    final void setValue(short index, byte[] bytes) {
        this.setValue(index, bytes, bytes.length);
    }

    public final void setValue(short index, byte[] bytes, int length) {
        this.checkInitialization();
        if (ClusterTraitsBase.isIllegalResourceIndex((int)index)) {
            throw new RuntimeDatabaseException("Assertion error. Illegal resource index=" + index);
        }
        if (length > Short.MAX_VALUE) {
            int len = this.setValueBig(index, bytes, length);
        } else {
            int len = this.setValueSmall(index, bytes, length);
        }
    }

    final void setImmutable(boolean immutable) {
        this.checkInitialization();
    }

    final void undoValueEx(int resourceIndex) {
        this.checkInitialization();
    }

    final void setDeleted(boolean deleted) {
        this.checkInitialization();
    }

    final void corrupt() {
        this.checkInitialization();
        this.addByte((byte)0);
    }

    public byte[] getBytes() {
        byte[] copy = new byte[this.byteIndex];
        System.arraycopy(this.bytes, 0, copy, 0, this.byteIndex);
        return copy;
    }

    final boolean flush(ClusterUID clusterUID) {
        throw new UnsupportedOperationException();
    }

    final void flushInternal(ClusterUID clusterUID) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return 31 * this.clusterUID.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ClusterChange)) {
            return false;
        }
        ClusterChange r = (ClusterChange)object;
        return r.clusterUID.equals((Object)this.clusterUID);
    }

    public void flush() {
        if (this.byteIndex > 0) {
            ClusterUID cuid = this.clusterUID;
            byte[] block = this.getBytes();
            byte[] raw = new byte[block.length + 28];
            Bytes.writeLE((byte[])raw, (int)0, (int)1);
            System.arraycopy(cuid.asBytes(), 0, raw, 4, 16);
            Bytes.writeLE((byte[])raw, (int)20, (int)block.length);
            System.arraycopy(block, 0, raw, 24, block.length);
            Bytes.writeLE((byte[])raw, (int)(24 + block.length), (int)0);
            ByteBuffer rawBB = ByteBuffer.wrap(raw);
            ByteBuffer outputBB = ByteBuffer.allocate(raw.length + raw.length / 8);
            int compressedSize = Compressions.get((String)"LZ4").compressBuffer(rawBB, 0, raw.length, outputBB, 0);
            byte[] data_ = null;
            if (compressedSize < raw.length) {
                data_ = new byte[compressedSize];
                outputBB.get(data_, 0, compressedSize);
            } else {
                data_ = raw;
            }
            byte[] data = new byte[data_.length + 24];
            Bytes.writeLE((byte[])data, (int)0, (int)0);
            Bytes.writeLE((byte[])data, (int)4, (int)0);
            Bytes.writeLE((byte[])data, (int)8, (int)raw.length);
            Bytes.writeLE((byte[])data, (int)12, (int)raw.length);
            Bytes.writeLE((byte[])data, (int)16, (int)data_.length);
            System.arraycopy(data_, 0, data, 20, data_.length);
            Bytes.writeLE((byte[])data, (int)(20 + data_.length), (int)0);
            this.stream.add((Pair<ClusterUID, byte[]>)Pair.make((Object)this.clusterUID, (Object)data));
            this.clear();
            this.initBuffer();
        }
    }

    final class DebugStm {
        ClusterStream.StmEnum e;
        int r;
        int p;
        int o;
        ClusterUID pc;
        ClusterUID oc;

        DebugStm(ClusterStream.StmEnum e, int r, int p, ClusterUID pc, int o, ClusterUID oc) {
            this.e = e;
            this.r = r;
            this.p = p;
            this.o = o;
            this.pc = pc;
            this.oc = oc;
        }

        public String toString() {
            short ri = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)this.r);
            short pi = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)this.p);
            short oi = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)this.o);
            return String.valueOf((Object)this.e) + " rk=" + this.r + " ri=" + ri + " rc=" + String.valueOf(ClusterChange.this.clusterUID) + " pk=" + this.p + " pi=" + pi + " pc=" + String.valueOf(this.pc) + " ok=" + this.o + " oi=" + oi + " oc=" + String.valueOf(this.oc);
        }

        public String toString2() {
            return String.valueOf((Object)this.e) + " r=" + this.r + " rc=" + String.valueOf(ClusterChange.this.clusterUID) + " p=" + this.p + " pc=" + String.valueOf(this.pc) + " o=" + this.o + " oc=" + String.valueOf(this.oc);
        }

        public String toString3() {
            short ri = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)this.r);
            short pi = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)this.p);
            short oi = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)this.o);
            return String.valueOf((Object)this.e) + " ri=" + ri + " pi=" + pi + " pc=" + String.valueOf(this.pc) + " oi=" + oi + " oc=" + String.valueOf(this.oc);
        }
    }

    final class ForeignTable {
        private final TLongIntHashMap table = new TLongIntHashMap();

        ForeignTable() {
        }

        private long createKey(short index, long cluster) {
            assert (cluster <= 0xFFFFFFFFFFFFL);
            return cluster << 14 | (long)index;
        }

        public int get(short index, long cluster) {
            int value = this.table.get(this.createKey(index, cluster));
            return value;
        }

        public int put(short index, long cluster, int value) {
            return this.table.put(this.createKey(index, cluster), value);
        }

        public int size() {
            return this.table.size();
        }

        public void clear() {
            this.table.clear();
        }
    }
}

