/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.cluster;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Consumer;
import org.simantics.acorn.cluster.ClusterImpl;
import org.simantics.acorn.cluster.SizeOfObjectTable;
import org.simantics.acorn.cluster.SizeOfPredicateTable;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.internal.ClusterSupport2;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ExternalValueException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ClusterTranslator;
import org.simantics.db.impl.ForEachObjectContextProcedure;
import org.simantics.db.impl.ForEachObjectProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueContextProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueProcedure;
import org.simantics.db.impl.IClusterTable;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procore.cluster.ClusterMap;
import org.simantics.db.procore.cluster.ClusterPrintDebugInfo;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.CompleteTable;
import org.simantics.db.procore.cluster.FlatTable;
import org.simantics.db.procore.cluster.ForeignTable;
import org.simantics.db.procore.cluster.ObjectTable;
import org.simantics.db.procore.cluster.PredicateTable;
import org.simantics.db.procore.cluster.ResourceTable;
import org.simantics.db.procore.cluster.ValueTable;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ValueStream;

public final class ClusterBig
extends ClusterImpl {
    private static final int TABLE_HEADER_SIZE = 8;
    private static final int RESOURCE_TABLE_OFFSET = 0;
    private static final int PREDICATE_TABLE_OFFSET = 8;
    private static final int OBJECT_TABLE_OFFSET = 16;
    private static final int VALUE_TABLE_OFFSET = 24;
    private static final int FLAT_TABLE_OFFSET = 32;
    private static final int COMPLETE_TABLE_OFFSET = 40;
    private static final int FOREIGN_TABLE_OFFSET = 48;
    private static final int INT_HEADER_SIZE = 56;
    private final int clusterBits;
    private final ResourceTable resourceTable;
    private final PredicateTable predicateTable;
    private final ObjectTable objectTable;
    private final ValueTable valueTable;
    private final FlatTable flatTable;
    private final ForeignTable foreignTable;
    private final CompleteTable completeTable;
    private final ClusterMap clusterMap;
    private final int[] headerTable;
    private final ClusterSupport2 clusterSupport;

    public ClusterBig(IClusterTable clusterTable, ClusterUID clusterUID, int clusterKey, ClusterSupport2 support) {
        super(clusterTable, clusterUID, clusterKey, support);
        this.headerTable = new int[56];
        this.resourceTable = new ResourceTable((TableSizeListener)this, this.headerTable, 0);
        this.foreignTable = new ForeignTable((TableSizeListener)this, this.headerTable, 48);
        this.predicateTable = new PredicateTable((TableSizeListener)this, this.headerTable, 8);
        this.objectTable = new ObjectTable((TableSizeListener)this, this.headerTable, 16);
        this.valueTable = new ValueTable((TableSizeListener)this, this.headerTable, 24);
        this.completeTable = new CompleteTable((TableSizeListener)this, this.headerTable, 40);
        this.flatTable = null;
        this.clusterMap = new ClusterMap(this.foreignTable, this.flatTable);
        this.clusterSupport = support;
        this.clusterBits = ClusterTraitsBase.getClusterBits((int)clusterKey);
        this.importance = 0L;
    }

    protected ClusterBig(IClusterTable clusterTable, long[] longs, int[] ints, byte[] bytes, ClusterSupport2 support, int clusterKey) throws DatabaseException {
        super(clusterTable, ClusterBig.checkValidity(0L, longs, ints, bytes), clusterKey, support);
        if (ints.length < 56) {
            throw new IllegalArgumentException("Too small integer table for cluster.");
        }
        this.headerTable = ints;
        this.resourceTable = new ResourceTable((TableSizeListener)this, ints, 0, longs);
        this.foreignTable = new ForeignTable((TableSizeListener)this, this.headerTable, 48, longs);
        this.predicateTable = new PredicateTable((TableSizeListener)this, ints, 8, ints);
        this.objectTable = new ObjectTable((TableSizeListener)this, ints, 16, ints);
        this.valueTable = new ValueTable((TableSizeListener)this, ints, 24, bytes);
        this.flatTable = null;
        this.completeTable = new CompleteTable((TableSizeListener)this, this.headerTable, 40, ints);
        this.clusterMap = new ClusterMap(this.foreignTable, this.flatTable);
        this.clusterSupport = support;
        this.clusterBits = ClusterTraitsBase.getClusterBits((int)clusterKey);
    }

    void analyse() {
        System.out.println("Cluster " + this.clusterId);
        System.out.println("-size:" + this.getUsedSpace());
        System.out.println(" -rt:" + (this.resourceTable.getTableCapacity() * 8 + 8));
        System.out.println(" -ft:" + this.foreignTable.getTableCapacity() * 8);
        System.out.println(" -pt:" + this.predicateTable.getTableCapacity() * 4);
        System.out.println(" -ot:" + this.objectTable.getTableCapacity() * 4);
        System.out.println(" -ct:" + this.completeTable.getTableCapacity() * 4);
        System.out.println(" -vt:" + this.valueTable.getTableCapacity());
        System.out.println("-resourceTable:");
        System.out.println(" -resourceCount=" + this.resourceTable.getResourceCount());
        System.out.println(" -size=" + this.resourceTable.getTableSize());
        System.out.println(" -capacity=" + this.resourceTable.getTableCapacity());
        System.out.println(" -count=" + this.resourceTable.getTableCount());
        System.out.println(" -size=" + this.resourceTable.getTableSize());
    }

    public void checkDirectReference(int dr) throws DatabaseException {
        if (!ClusterTraits.statementIndexIsDirect((int)dr)) {
            throw new ValidationException("Reference is not direct. Reference=" + dr);
        }
        if (ClusterTraits.isFlat((int)dr)) {
            throw new ValidationException("Reference is flat. Reference=" + dr);
        }
        if (ClusterTraits.isLocal((int)dr)) {
            if (dr < 1 || dr > this.resourceTable.getUsedSize()) {
                throw new ValidationException("Illegal local reference. Reference=" + dr);
            }
        } else {
            int fi = ClusterTraits.getForeignIndexFromReference((int)dr);
            int ri = ClusterTraits.getResourceIndexFromForeignReference((int)dr);
            if (fi < 1 || fi > this.foreignTable.getUsedSize()) {
                throw new ValidationException("Illegal foreign reference. Reference=" + dr + " foreign index=" + fi);
            }
            if (ri < 1 || ri > ClusterTraits.getMaxNumberOfResources()) {
                throw new ValidationException("Illegal foreign reference. Reference=" + dr + " resource index=" + ri);
            }
        }
    }

    public void checkPredicateIndex(int pi) throws DatabaseException {
        this.predicateTable.checkPredicateSetIndex((ClusterBase)this, pi);
    }

    public void checkObjectSetReference(int or) throws DatabaseException {
        if (ClusterTraits.statementIndexIsDirect((int)or)) {
            throw new ValidationException("Illegal object set reference. Reference=" + or);
        }
        int oi = ClusterTraits.statementIndexGet((int)or);
        this.objectTable.checkObjectSetIndex((ClusterBase)this, oi);
    }

    public void checkValueInit() throws DatabaseException {
        this.valueTable.checkValueInit();
    }

    public void checkValue(int capacity, int index) throws DatabaseException {
        this.valueTable.checkValue(capacity, index);
    }

    public void checkValueFini() throws DatabaseException {
        this.valueTable.checkValueFini();
    }

    public void checkForeingIndex(int fi) throws DatabaseException {
        if (fi < 1 || fi > this.foreignTable.getUsedSize()) {
            throw new ValidationException("Illegal foreign index=" + fi);
        }
    }

    public void checkCompleteSetReference(int cr) throws DatabaseException {
        if (!ClusterTraits.completeReferenceIsMultiple((int)cr)) {
            throw new ValidationException("Illegal complete set reference. Reference=" + cr);
        }
        int ci = cr;
        this.completeTable.checkCompleteSetIndex((ClusterBase)this, ci);
    }

    public void check() throws DatabaseException {
        this.completeTable.check((ClusterBase)this);
        this.objectTable.check((ClusterBase)this);
        this.predicateTable.check((ClusterBase)this);
        this.resourceTable.check((ClusterBase)this);
    }

    public ClusterI.CompleteTypeEnum getCompleteType(int resourceKey, ClusterSupport support) throws DatabaseException {
        short resourceRef = this.getLocalReference(resourceKey);
        int completeRef = this.resourceTable.getCompleteObjectRef((int)resourceRef);
        ClusterI.CompleteTypeEnum ct = ClusterTraits.completeReferenceGetType((int)completeRef);
        byte i = ct.getValue();
        switch (i) {
            case 0: {
                return ClusterI.CompleteTypeEnum.NotComplete;
            }
            case 1: {
                return ClusterI.CompleteTypeEnum.InstanceOf;
            }
            case 2: {
                return ClusterI.CompleteTypeEnum.Inherits;
            }
            case 3: {
                return ClusterI.CompleteTypeEnum.SubrelationOf;
            }
        }
        throw new DatabaseException("Illegal complete type enumeration.");
    }

    public int getCompleteObjectKey(int resourceKey, ClusterSupport support) throws DatabaseException {
        int clusterIndex;
        short resourceRef = this.getLocalReference(resourceKey);
        int completeRef = this.resourceTable.getCompleteObjectRef((int)resourceRef);
        int resourceIndex = ClusterTraits.completeReferenceGetResourceIndex((int)completeRef);
        ClusterI.CompleteTypeEnum completeType = ClusterTraits.completeReferenceGetType((int)completeRef);
        if (completeType == ClusterI.CompleteTypeEnum.NotComplete) {
            throw new DatabaseException("Resource has multiple complete objects. Resource key=" + resourceKey + ".");
        }
        if (ClusterTraits.completeReferenceIsLocal((int)completeRef)) {
            clusterIndex = this.clusterKey;
        } else {
            int foreignIndex = ClusterTraits.completeReferenceGetForeignIndex((int)completeRef);
            ClusterUID clusterUID = this.foreignTable.getResourceUID(foreignIndex).asCID();
            clusterIndex = this.clusterSupport.getClusterKeyByClusterUIDOrMake(clusterUID);
        }
        int key = ClusterTraits.createResourceKey((int)clusterIndex, (int)resourceIndex);
        return key;
    }

    public boolean isComplete(int resourceKey, ClusterSupport support) throws DatabaseException {
        short resourceRef = this.getLocalReference(resourceKey);
        int completeRef = this.resourceTable.getCompleteObjectRef((int)resourceRef);
        ClusterI.CompleteTypeEnum completeType = ClusterTraits.completeReferenceGetType((int)completeRef);
        boolean complete = completeType != ClusterI.CompleteTypeEnum.NotComplete;
        return complete;
    }

    public int getSingleObject(int resourceKey, int predicateKey, int objectIndex, ClusterSupport support) throws DatabaseException {
        if (objectIndex == 0) {
            short resourceIndex = this.getLocalReference(resourceKey);
            int pRef = this.getInternalReferenceOrZero(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, this.completeTable, (Modifier)this);
        }
        return this.objectTable.getSingleObject(objectIndex, support, (Modifier)this);
    }

    public void forObjects(int resourceKey, int predicateKey, int objectIndex, QueryProcessor processor, ReadGraphImpl graph, SyncMultiProcedure<Resource> procedure, ClusterSupport support) throws DatabaseException {
        if (objectIndex == 0) {
            short resourceIndex = this.getLocalReference(resourceKey);
            int pRef = this.getInternalReferenceOrZero(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            this.resourceTable.foreachObject((int)resourceIndex, graph, procedure, support, pRef, pCompleteType, this.completeTable, (Modifier)this);
            return;
        }
        this.objectTable.foreachObject(graph, objectIndex, procedure, (Modifier)this);
    }

    public <C> void forObjects(int resourceKey, int predicateKey, int objectIndex, QueryProcessor processor, ReadGraphImpl graph, C context, SyncContextMultiProcedure<C, Resource> procedure, ClusterSupport support) throws DatabaseException {
        if (objectIndex == 0) {
            short resourceIndex = this.getLocalReference(resourceKey);
            int pRef = this.getInternalReferenceOrZero(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            this.resourceTable.foreachObject((int)resourceIndex, graph, context, procedure, support, pRef, pCompleteType, this.completeTable, (Modifier)this);
            return;
        }
        this.objectTable.foreachObject(graph, objectIndex, context, procedure, (Modifier)this);
    }

    public <Context> boolean forObjects(int resourceKey, int predicateKey, int objectIndex, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        if (objectIndex == 0) {
            short resourceIndex = this.getLocalReference(resourceKey);
            int pRef = this.getInternalReferenceOrZero(predicateKey, support);
            ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
            return this.resourceTable.foreachObject((int)resourceIndex, procedure, context, support, (Modifier)this, pRef, pCompleteType, this.completeTable);
        }
        return this.objectTable.foreachObject(objectIndex, procedure, context, support, (Modifier)this);
    }

    public int getSingleObject(int resourceKey, int predicateKey, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReference(resourceKey);
        int pRef = this.getInternalReferenceOrZero(predicateKey, support);
        ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, this.completeTable, (Modifier)this);
        }
        int predicateIndex = this.resourceTable.getPredicateIndex((int)resourceIndex);
        if (predicateIndex == 0) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, this.completeTable, (Modifier)this);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef);
        return this.getSingleObject(resourceKey, predicateKey, objectIndex, support);
    }

    public <T> int getSingleObject(int resourceKey, ForPossibleRelatedValueProcedure<T> procedure, ClusterSupport support) throws DatabaseException {
        int predicateKey = procedure.predicateKey;
        short resourceIndex = this.getLocalReference(resourceKey);
        int pRef = this.getInternalReferenceOrZero(predicateKey, support);
        ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, this.completeTable, (Modifier)this);
        }
        int predicateIndex = this.resourceTable.getPredicateIndex((int)resourceIndex);
        if (predicateIndex == 0) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, this.completeTable, (Modifier)this);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef);
        return this.getSingleObject(resourceKey, predicateKey, objectIndex, support);
    }

    public <C, T> int getSingleObject(int resourceKey, ForPossibleRelatedValueContextProcedure<C, T> procedure, ClusterSupport support) throws DatabaseException {
        int predicateKey = procedure.predicateKey;
        short resourceIndex = this.getLocalReference(resourceKey);
        int pRef = this.getInternalReferenceOrZero(predicateKey, support);
        ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, this.completeTable, (Modifier)this);
        }
        int predicateIndex = this.resourceTable.getPredicateIndex((int)resourceIndex);
        if (predicateIndex == 0) {
            return this.resourceTable.getSingleObject((int)resourceIndex, support, pRef, pCompleteType, this.completeTable, (Modifier)this);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef);
        return this.getSingleObject(resourceKey, predicateKey, objectIndex, support);
    }

    public void forObjects(ReadGraphImpl graph, int resourceKey, int predicateKey, SyncMultiProcedure<Resource> procedure) throws DatabaseException {
        SessionImplSocket session = (SessionImplSocket)graph.getSession();
        ClusterTranslator support = session.clusterTranslator;
        short resourceIndex = this.getLocalReference(resourceKey);
        int pRef = this.getInternalReferenceOrZero(predicateKey, (ClusterSupport)support);
        ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            this.resourceTable.foreachObject((int)resourceIndex, graph, procedure, (ClusterSupport)support, pRef, pCompleteType, this.completeTable, (Modifier)this);
            return;
        }
        int predicateIndex = this.resourceTable.getPredicateIndex((int)resourceIndex);
        if (predicateIndex == 0) {
            this.resourceTable.foreachObject((int)resourceIndex, graph, procedure, (ClusterSupport)support, pRef, pCompleteType, this.completeTable, (Modifier)this);
            return;
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef);
        this.forObjects(resourceKey, predicateKey, objectIndex, graph.processor, graph, procedure, (ClusterSupport)support);
    }

    public void forObjects(ReadGraphImpl graph, int resourceKey, ForEachObjectProcedure procedure) throws DatabaseException {
        SessionImplSocket session = (SessionImplSocket)graph.getSession();
        ClusterTranslator support = session.clusterTranslator;
        int predicateKey = procedure.predicateKey;
        short resourceIndex = this.getLocalReference(resourceKey);
        int pRef = this.getInternalReferenceOrZero(predicateKey, (ClusterSupport)support);
        ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            this.resourceTable.foreachObject((int)resourceIndex, graph, (SyncMultiProcedure)procedure, (ClusterSupport)support, pRef, pCompleteType, this.completeTable, (Modifier)this);
            return;
        }
        int predicateIndex = this.resourceTable.getPredicateIndex((int)resourceIndex);
        if (predicateIndex == 0) {
            this.resourceTable.foreachObject((int)resourceIndex, graph, (SyncMultiProcedure)procedure, (ClusterSupport)support, pRef, pCompleteType, this.completeTable, (Modifier)this);
            return;
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef);
        this.forObjects(resourceKey, predicateKey, objectIndex, graph.processor, graph, (SyncMultiProcedure<Resource>)procedure, (ClusterSupport)support);
    }

    public <C> void forObjects(ReadGraphImpl graph, int resourceKey, C context, ForEachObjectContextProcedure<C> procedure) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public <Context> boolean forObjects(int resourceKey, int predicateKey, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReference(resourceKey);
        int pRef = this.getInternalReferenceOrZero(predicateKey, support);
        ClusterI.CompleteTypeEnum pCompleteType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)predicateKey);
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            return this.resourceTable.foreachObject((int)resourceIndex, procedure, context, support, (Modifier)this, pRef, pCompleteType, this.completeTable);
        }
        int predicateIndex = this.resourceTable.getPredicateIndex((int)resourceIndex);
        if (predicateIndex == 0) {
            return this.resourceTable.foreachObject((int)resourceIndex, procedure, context, support, (Modifier)this, pRef, pCompleteType, this.completeTable);
        }
        int objectIndex = this.predicateTable.getObjectIndex(predicateIndex, pRef);
        return this.forObjects(resourceKey, predicateKey, objectIndex, procedure, context, support);
    }

    public <Context> boolean forPredicates(int resourceKey, ClusterI.PredicateProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReference(resourceKey);
        int predicateIndex = this.resourceTable.getPredicateIndex((int)resourceIndex);
        if (predicateIndex == 0) {
            return this.resourceTable.foreachPredicate((int)resourceIndex, procedure, context, support, (Modifier)this, this.completeTable);
        }
        boolean broken = this.resourceTable.foreachPredicate((int)resourceIndex, procedure, context, support, (Modifier)this, this.completeTable);
        if (broken) {
            return true;
        }
        return this.predicateTable.foreachPredicate(predicateIndex, procedure, context, support, (Modifier)this);
    }

    @Override
    public ClusterI addRelation(int sResourceKey, ClusterUID puid, int pResourceKey, ClusterUID ouid, int oResourceKey, ClusterSupport support) throws DatabaseException {
        ClusterI.CompleteTypeEnum completeType;
        int ori;
        int pri;
        int sri = this.getLocalReferenceAnd(sResourceKey, support, (byte)2);
        boolean ret = this.addRelationInternal(sri, pri = this.getReferenceOrCreateIfForeign(pResourceKey, puid, support, (byte)0), ori = this.getReferenceOrCreateIfForeign(oResourceKey, ouid, support, (byte)0), completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)pResourceKey));
        if (ret) {
            support.addStatement((Object)this);
            return this;
        }
        support.cancelStatement((Object)this);
        return null;
    }

    public ClusterI addRelation(int sResourceKey, int pResourceKey, int oResourceKey, ClusterSupport support) throws DatabaseException {
        ClusterI.CompleteTypeEnum completeType;
        int ori;
        int pri;
        int sri = this.getLocalReferenceAnd(sResourceKey, support, (byte)2);
        boolean ret = this.addRelationInternal(sri, pri = this.getReferenceOrCreateIfForeign(pResourceKey, support, (byte)0), ori = this.getReferenceOrCreateIfForeign(oResourceKey, support, (byte)0), completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)pResourceKey));
        if (ret) {
            support.addStatement((Object)this);
            return this;
        }
        support.cancelStatement((Object)this);
        return null;
    }

    public boolean removeRelation(int sResourceKey, int pResourceKey, int oResourceKey, ClusterSupport support) throws DatabaseException {
        int sri = this.getLocalReferenceAnd(sResourceKey, support, (byte)3);
        int pri = this.getInternalReferenceOrZeroAnd(pResourceKey, support, (byte)0);
        int ori = this.getInternalReferenceOrZeroAnd(oResourceKey, support, (byte)0);
        boolean ret = false;
        if (pri != 0 && ori != 0) {
            ClusterI.CompleteTypeEnum completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)pResourceKey);
            ret = this.removeRelationInternal(sri, pri, ori, completeType, support);
        }
        if (ret) {
            support.removeStatement((Object)this);
        } else {
            support.cancelStatement((Object)this);
        }
        return ret;
    }

    public void denyRelation(int sResourceKey, int pResourceKey, int oResourceKey, ClusterSupport support) throws DatabaseException {
        int sri = this.checkResourceKeyIsOursAndGetResourceIndexIf(sResourceKey, support);
        ResourceIndexAndId p = this.checkResourceKeyAndGetResourceIndexIf(pResourceKey, support);
        ResourceIndexAndId o = this.checkResourceKeyAndGetResourceIndexIf(oResourceKey, support);
        if (sri == 0 || p.index == 0 || o.index == 0) {
            return;
        }
        ClusterI.CompleteTypeEnum completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey((int)pResourceKey);
        boolean ret = this.removeRelationInternal(sri, p.reference, o.reference, completeType, support);
        if (ret) {
            support.addStatementIndex((Object)this, sResourceKey, this.getClusterUID(), (byte)3);
            support.addStatementIndex((Object)this, pResourceKey, p.clusterUID, (byte)0);
            support.addStatementIndex((Object)this, oResourceKey, o.clusterUID, (byte)0);
            support.removeStatement((Object)this);
        }
    }

    public InputStream getValueStream(int rResourceId, ClusterSupport support) throws DatabaseException {
        byte[] buffer;
        block3: {
            short resourceIndex = this.getLocalReference(rResourceId);
            try {
                buffer = this.resourceTable.getValue(this.valueTable, (int)resourceIndex);
                if (buffer != null) break block3;
                return null;
            }
            catch (ExternalValueException externalValueException) {
                return support.getValueStreamEx((int)resourceIndex, this.clusterUID.second);
            }
        }
        return new ValueStream(buffer);
    }

    public byte[] getValue(int rResourceId, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReference(rResourceId);
        try {
            return this.resourceTable.getValue(this.valueTable, (int)resourceIndex);
        }
        catch (ExternalValueException externalValueException) {
            try {
                return this.clusterSupport.impl.getResourceFile(this.clusterUID.asBytes(), resourceIndex);
            }
            catch (AcornAccessVerificationException | IllegalAcornStateException e1) {
                throw new DatabaseException((Throwable)e1);
            }
        }
    }

    public boolean hasValue(int rResourceId, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReference(rResourceId);
        return this.resourceTable.hasValue((int)resourceIndex);
    }

    public boolean removeValue(int rResourceId, ClusterSupport support) throws DatabaseException {
        int resourceIndex = this.getLocalReferenceAnd(rResourceId, support, (byte)5);
        support.removeValue((Object)this);
        return this.resourceTable.removeValue(this.valueTable, resourceIndex);
    }

    public ClusterI setValue(int rResourceId, byte[] value, int length, ClusterSupport support) throws DatabaseException {
        int resourceIndex = this.getLocalReferenceAnd(rResourceId, support, (byte)4);
        support.setValue((Object)this, this.getClusterId(), value, length);
        this.resourceTable.setValue(this.valueTable, resourceIndex, value, length);
        return this;
    }

    public ClusterI modiValueEx(int rResourceId, long voffset, int length, byte[] value, int offset, ClusterSupport support) throws DatabaseException {
        int resourceIndex = this.getLocalReferenceAnd(rResourceId, support, (byte)6);
        support.modiValue((Object)this, this.getClusterId(), voffset, length, value, offset);
        this.resourceTable.setValueEx(this.valueTable, resourceIndex);
        return this;
    }

    public byte[] readValueEx(int rResourceId, long voffset, int length, ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.getLocalReference(rResourceId);
        boolean isExternal = this.resourceTable.isValueEx(this.valueTable, (int)resourceIndex);
        if (!isExternal) {
            throw new DatabaseException("ClusterI.readValue supported only for external value. Resource key=" + rResourceId);
        }
        return support.getValueEx((int)resourceIndex, this.getClusterId(), voffset, length);
    }

    public long getValueSizeEx(int resourceKey, ClusterSupport support) throws DatabaseException, ExternalValueException {
        short resourceIndex = this.getLocalReference(resourceKey);
        boolean isExternal = this.resourceTable.isValueEx(this.valueTable, (int)resourceIndex);
        if (!isExternal) {
            throw new ExternalValueException("ClusterI.getSize supported only for external value. Resource key=" + resourceKey);
        }
        return support.getValueSizeEx((int)resourceIndex, this.getClusterId());
    }

    @Override
    public boolean isValueEx(int resourceKey) throws DatabaseException {
        short resourceIndex = this.getLocalReference(resourceKey);
        return this.resourceTable.isValueEx(this.valueTable, (int)resourceIndex);
    }

    public void setValueEx(int resourceKey) throws DatabaseException {
        short resourceIndex = this.getLocalReference(resourceKey);
        this.resourceTable.setValueEx(this.valueTable, (int)resourceIndex);
    }

    public int createResource(ClusterSupport support) throws DatabaseException {
        short resourceIndex = this.resourceTable.createResource();
        support.createResource((Object)this, resourceIndex, this.clusterId);
        return ClusterTraits.createResourceKey((int)this.clusterKey, (int)resourceIndex);
    }

    public boolean hasResource(int resourceKey, ClusterSupport support) {
        short resourceIndex;
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            return false;
        }
        try {
            resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        }
        catch (DatabaseException databaseException) {
            return false;
        }
        return resourceIndex > 0 & resourceIndex <= this.resourceTable.getTableCount();
    }

    public int getNumberOfResources(ClusterSupport support) {
        return this.resourceTable.getUsedSize();
    }

    public long getUsedSpace() {
        long rt = this.resourceTable.getTableCapacity() * 8 + 8;
        long ft = this.foreignTable.getTableCapacity() * 8;
        long pt = this.predicateTable.getTableCapacity() * 4;
        long ot = this.objectTable.getTableCapacity() * 4;
        long ct = this.completeTable.getTableCapacity() * 4;
        long vt = this.valueTable.getTableCapacity() * 1;
        long cm = this.clusterMap.getUsedSpace();
        return rt + ft + pt + ot + ct + vt + cm;
    }

    int getRealSizeOfPredicateTable() throws DatabaseException {
        SizeOfPredicateTable proc = new SizeOfPredicateTable(this.resourceTable, this.predicateTable);
        this.resourceTable.foreachResource((ClusterI.ObjectProcedure)proc, (Object)0, null, null);
        return proc.getSize();
    }

    int getRealSizeOfObjectTable() throws DatabaseException {
        SizeOfObjectTable proc = new SizeOfObjectTable(this.resourceTable, this.predicateTable, this.objectTable);
        this.resourceTable.foreachResource((ClusterI.ObjectProcedure)proc, (Object)0, null, null);
        return proc.getSize();
    }

    public boolean isEmpty() {
        return this.resourceTable.getTableCount() == 0;
    }

    public void printDebugInfo(String message, ClusterSupport support) throws DatabaseException {
        this.predicateTable.printDebugInfo();
        this.objectTable.printDebugInfo();
        ClusterPrintDebugInfo proc = new ClusterPrintDebugInfo((ClusterBase)this, this.resourceTable, this.predicateTable, support, this.objectTable);
        this.resourceTable.foreachResource((ClusterI.ObjectProcedure)proc, (Object)0, null, null);
    }

    private int getInternalReferenceOrZero(int resourceKey, ClusterSupport support) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            ClusterUID clusterUID = this.clusterSupport.getClusterUIDByResourceKey(resourceKey);
            int foreignResourceIndex = this.clusterMap.getForeignReferenceOrZero((int)resourceIndex, clusterUID);
            return foreignResourceIndex;
        }
        return resourceIndex;
    }

    private int getInternalReferenceOrZeroAnd(int resourceKey, ClusterSupport support, byte op) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            ClusterUID clusterUID = this.clusterSupport.getClusterUIDByResourceKey(resourceKey);
            int foreignResourceIndex = this.clusterMap.getForeignReferenceOrZero((int)resourceIndex, clusterUID);
            support.addStatementIndex((Object)this, resourceKey, clusterUID, op);
            return foreignResourceIndex;
        }
        support.addStatementIndex((Object)this, resourceKey, this.getClusterUID(), op);
        return resourceIndex;
    }

    private short getLocalReference(int resourceKey) throws DatabaseException {
        return ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow((int)resourceKey);
    }

    private int getLocalReferenceAnd(int resourceKey, ClusterSupport support, byte op) throws DatabaseException {
        short resourceIndex = this.getLocalReference(resourceKey);
        support.addStatementIndex((Object)this, resourceKey, this.getClusterUID(), op);
        return resourceIndex;
    }

    private int checkResourceKeyIsOursAndGetResourceIndexIf(int resourceKey, ClusterSupport support) throws DatabaseException {
        int clusterShortId = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterShortId) {
            return 0;
        }
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        return resourceIndex;
    }

    private int getReferenceOrCreateIfForeign(int resourceKey, ClusterUID clusterUID, ClusterSupport support, byte op) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            support.addStatementIndex((Object)this, resourceKey, clusterUID, op);
            return this.clusterMap.getForeignReferenceOrCreateByResourceKey(resourceKey, clusterUID);
        }
        support.addStatementIndex((Object)this, resourceKey, this.getClusterUID(), op);
        return resourceIndex;
    }

    private int getReferenceOrCreateIfForeign(int resourceKey, ClusterSupport support, byte op) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            ClusterUID clusterUID = this.clusterSupport.getClusterUIDByResourceKey(resourceKey);
            support.addStatementIndex((Object)this, resourceKey, clusterUID, op);
            return this.clusterMap.getForeignReferenceOrCreateByResourceKey(resourceKey, clusterUID);
        }
        support.addStatementIndex((Object)this, resourceKey, this.getClusterUID(), op);
        return resourceIndex;
    }

    private ResourceIndexAndId checkResourceKeyAndGetResourceIndexIf(int resourceKey, ClusterSupport support) throws DatabaseException {
        int clusterKey = ClusterTraits.getClusterKeyFromResourceKey((int)resourceKey);
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)resourceKey);
        if (this.clusterKey != clusterKey) {
            ClusterBase foreignCluster = support.getClusterByClusterKey(clusterKey);
            ClusterUID clusterUID = foreignCluster.getClusterUID();
            int ref = this.clusterMap.getForeignReferenceOrCreateByResourceIndex((int)resourceIndex, clusterUID);
            return new ResourceIndexAndId(ref, resourceIndex, clusterUID);
        }
        return new ResourceIndexAndId(resourceIndex, resourceIndex, this.getClusterUID());
    }

    public final int execute(int resourceIndex) throws DatabaseException {
        int key;
        if (resourceIndex > 0) {
            key = this.clusterBits | resourceIndex;
        } else {
            ClusterUID clusterUID = this.clusterMap.getResourceUID(resourceIndex).asCID();
            int clusterKey = this.clusterSupport.getClusterKeyByClusterUIDOrMake(clusterUID);
            int foreingResourceIndex = this.clusterMap.getForeignResourceIndex(resourceIndex);
            key = ClusterTraits.createResourceKey((int)clusterKey, (int)foreingResourceIndex);
        }
        return key;
    }

    private boolean addRelationInternal(int sReference, int pReference, int oReference, ClusterI.CompleteTypeEnum completeType) throws DatabaseException {
        int predicateIndex = this.resourceTable.addStatement(sReference, pReference, oReference, this.predicateTable, this.objectTable, completeType, this.completeTable);
        if (predicateIndex == 0) {
            return true;
        }
        if (predicateIndex < 0) {
            return false;
        }
        int newPredicateIndex = this.predicateTable.addPredicate(predicateIndex, pReference, oReference, this.objectTable);
        if (newPredicateIndex == 0) {
            return false;
        }
        if (predicateIndex != newPredicateIndex) {
            this.resourceTable.setPredicateIndex(sReference, newPredicateIndex);
        }
        return true;
    }

    private boolean removeRelationInternal(int sResourceIndex, int pResourceIndex, int oResourceIndex, ClusterI.CompleteTypeEnum completeType, ClusterSupport support) throws DatabaseException {
        int predicateIndex = this.resourceTable.getPredicateIndex(sResourceIndex);
        if (predicateIndex == 0 || ClusterI.CompleteTypeEnum.NotComplete != completeType) {
            return this.resourceTable.removeStatementFromCache(sResourceIndex, pResourceIndex, oResourceIndex, completeType, this.completeTable);
        }
        PredicateTable.Status ret = this.predicateTable.removePredicate(predicateIndex, pResourceIndex, oResourceIndex, this.objectTable);
        switch (ret) {
            case NothingRemoved: {
                return false;
            }
            case PredicateRemoved: {
                if (this.predicateTable.getPredicateSetSize(predicateIndex) != 0) break;
                this.resourceTable.setPredicateIndex(sResourceIndex, 0);
            }
        }
        this.resourceTable.removeStatement(sResourceIndex, pResourceIndex, oResourceIndex, completeType, this.completeTable, this.predicateTable, this.objectTable, (ClusterBase)this, support);
        return true;
    }

    public void load() {
        throw new Error("Not supported.");
    }

    public void load(Consumer<DatabaseException> r) {
        throw new Error("Not supported.");
    }

    public int makeResourceKey(int resourceIndex) throws DatabaseException {
        int key = 0;
        if (resourceIndex > 0) {
            key = ClusterTraits.createResourceKey((int)this.clusterKey, (int)resourceIndex);
        } else {
            ClusterUID clusterUID = this.clusterMap.getResourceUID(resourceIndex).asCID();
            int clusterKey = this.clusterSupport.getClusterKeyByClusterUIDOrMake(clusterUID);
            int foreingResourceIndex = this.clusterMap.getForeignResourceIndex(resourceIndex);
            key = ClusterTraits.createResourceKey((int)clusterKey, (int)foreingResourceIndex);
        }
        if (key == 0) {
            throw new DatabaseException("Failed to make resource key from " + resourceIndex);
        }
        return key;
    }

    public ClusterBig toBig(ClusterSupport support) throws DatabaseException {
        throw new Error("Not implemented");
    }

    public void load(ClusterSupport session, Runnable callback) {
        throw new Error("Not implemented");
    }

    public ClusterI getClusterByResourceKey(int resourceKey, ClusterSupport support) {
        throw new Error("Not implemented");
    }

    public void increaseReferenceCount(int amount) {
        throw new Error("Not implemented");
    }

    public void decreaseReferenceCount(int amount) {
        throw new Error("Not implemented");
    }

    public int getReferenceCount() {
        throw new Error("Not implemented");
    }

    public void releaseMemory() {
    }

    public void compact() {
        this.clusterMap.compact();
    }

    public boolean contains(int resourceKey) {
        return ClusterTraitsBase.isCluster((int)this.clusterBits, (int)resourceKey);
    }

    public ClusterI.ClusterTypeEnum getType() {
        return ClusterI.ClusterTypeEnum.BIG;
    }

    public boolean getImmutable() {
        int status = this.resourceTable.getClusterStatus();
        return (status & 1) == 1;
    }

    public void setImmutable(boolean immutable, ClusterSupport support) {
        int status = this.resourceTable.getClusterStatus();
        status = immutable ? (status |= 1) : (status &= 0xFFFFFFFE);
        this.resourceTable.setClusterStatus(status);
        support.setImmutable((Object)this, immutable);
    }

    @Override
    public ClusterImpl.ClusterTables store() throws IOException {
        ClusterImpl.ClusterTables result = new ClusterImpl.ClusterTables();
        int[] currentHeader = Arrays.copyOf(this.headerTable, 56);
        int byteSize = this.valueTable.getTableSize();
        byte[] byteBytes = new byte[byteSize];
        this.valueTable.store((Object)byteBytes, 0);
        result.bytes = byteBytes;
        int longSize = 7 + this.resourceTable.getTableSize() + this.foreignTable.getTableSize();
        long[] longBytes = new long[longSize];
        longBytes[0] = 0L;
        longBytes[1] = 1L;
        longBytes[2] = 0L;
        longBytes[3] = this.clusterUID.second;
        int longPos = this.resourceTable.store((Object)longBytes, 7);
        this.foreignTable.store((Object)longBytes, longPos);
        result.longs = longBytes;
        int intSize = 56 + this.predicateTable.getTableSize() + this.objectTable.getTableSize() + this.completeTable.getTableSize();
        int[] intBytes = new int[intSize];
        int intPos = 56;
        intPos = this.predicateTable.store((Object)intBytes, intPos);
        intPos = this.objectTable.store((Object)intBytes, intPos);
        intPos = this.completeTable.store((Object)intBytes, intPos);
        int i = 0;
        while (i < 56) {
            int v;
            intBytes[i] = v = this.headerTable[i];
            ++i;
        }
        result.ints = intBytes;
        i = 0;
        while (i < 56) {
            this.headerTable[i] = currentHeader[i];
            ++i;
        }
        return result;
    }

    @Override
    protected int getResourceTableCount() {
        return this.resourceTable.getTableCount();
    }

    public boolean getDeleted() {
        int status = this.resourceTable.getClusterStatus();
        return (status & 2) == 2;
    }

    public void setDeleted(boolean deleted, ClusterSupport support) {
        int status = this.resourceTable.getClusterStatus();
        status = deleted ? (status |= 2) : (status &= 0xFFFFFFFD);
        this.resourceTable.setClusterStatus(status);
        support.setDeleted((Object)this, deleted);
    }

    public Table<?> getPredicateTable() {
        return this.predicateTable;
    }

    public Table<?> getForeignTable() {
        return this.foreignTable;
    }

    public Table<?> getCompleteTable() {
        return this.completeTable;
    }

    public Table<?> getValueTable() {
        return this.valueTable;
    }

    public Table<?> getObjectTable() {
        return this.objectTable;
    }

    private class ResourceIndexAndId {
        public final int reference;
        public final int index;
        public final ClusterUID clusterUID;

        ResourceIndexAndId(int reference, int index, ClusterUID clusterUID) {
            this.reference = reference;
            this.index = index;
            this.clusterUID = clusterUID;
        }
    }
}

