/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.simantics.databoard.file.RuntimeIOException;
import org.simantics.db.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIO
implements IO {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileIO.class);
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];
    private static final Set<OpenOption> CREATE_OPTIONS = Set.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    private static final Set<OpenOption> APPEND_OPTIONS = Set.of(StandardOpenOption.APPEND);
    private Path path;
    private int writePosition = 0;
    private static final boolean TRACE_PERF = false;

    public FileIO(Path path) {
        this.path = path;
    }

    public synchronized int saveBytes(byte[] bytes, int length, boolean overwrite) throws IOException {
        if (overwrite) {
            this.writePosition = 0;
        }
        int result = this.writePosition;
        long start = System.nanoTime();
        Set<OpenOption> options = this.writePosition == 0 ? CREATE_OPTIONS : APPEND_OPTIONS;
        ByteBuffer bb = ByteBuffer.wrap(bytes, 0, length);
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try (FileChannel fc = FileChannel.open(this.path, options, NO_ATTRIBUTES);){
                int written = 0;
                while (written < length) {
                    written += fc.write(bb);
                }
                this.writePosition += written;
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            throw new IOException("An error occured file saving bytes for file " + this.path.toAbsolutePath().toString(), t);
        }
    }

    public synchronized byte[] readBytes(long offset, int length) throws IOException {
        long start = System.nanoTime();
        Throwable throwable = null;
        Object var7_6 = null;
        try (SeekableByteChannel channel = Files.newByteChannel(this.path, new OpenOption[0]);){
            channel.position(offset);
            ByteBuffer buf = ByteBuffer.allocate(length);
            int read = 0;
            while (read < length) {
                read += channel.read(buf);
            }
            byte[] result = buf.array();
            if (result.length != length) {
                LOGGER.info("result length does not match expected {} {} {}", new Object[]{this, result.length, length});
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public synchronized long length() throws IOException {
        return Files.size(this.path);
    }

    public static void syncPath(Path f) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (RandomAccessFile raf = new RandomAccessFile(f.toFile(), "rw");){
            raf.getFD().sync();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static void uncheckedSyncPath(Path f) {
        try {
            FileIO.syncPath(f);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        byte[] buf = new byte[0x100000];
        long s = System.nanoTime();
        Path test = Paths.get("e:/work/test.dat", new String[0]);
        OutputStream fs = Files.newOutputStream(test, new OpenOption[0]);
        BufferedOutputStream os = new BufferedOutputStream(fs, 131072);
        int i = 0;
        while (i < 40) {
            ((OutputStream)os).write(buf);
            ++i;
        }
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        FileIO.syncPath(test);
        if (LOGGER.isDebugEnabled()) {
            long duration = System.nanoTime() - s;
            LOGGER.info("Took " + 1.0E-6 * (double)duration + "ms.");
        }
    }
}

